<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Breakpoint;


use Comitium5\DesignerBundle\Model\Interfaces\DateTimeInterface;
use Comitium5\DesignerBundle\Model\Interfaces\EnabledInterface;

/**
 * Interface BreakpointInterface.
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 */
interface BreakpointInterface extends
    DateTimeInterface,
    EnabledInterface
{
    /**
     * @return string
     */
    public function getName();

    /**
     * @param string $name
     *
     * @return self
     */
    public function setName(string $name);

    /**
     * @return int
     */
    public function getMinWidth();

    /**
     * @param int $width
     *
     * @return self
     */
    public function setMinWidth($width);

    /**
     * @return int
     */
    public function getMaxWidth();

    /**
     * @param int $width
     *
     * @return self
     */
    public function setMaxWidth($width);

    /**
     * @return string
     */
    public function getType();

    /**
     * @param string $type
     *
     * @return self
     */
    public function setType(string $type);
}
