<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Breakpoint;

use Doctrine\Common\Collections\Collection;

/**
 * Interface BreakpointCollectionInterface
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Breakpoint
 */
interface BreakpointCollectionInterface
{
    /**
     * @param BreakpointInterface $breakpoint
     * @return self
     */
    public function addBreakpoint(BreakpointInterface $breakpoint);

    /**
     * @param BreakpointInterface $breakpoint
     * @return self
     */
    public function removeBreakpoint(BreakpointInterface $breakpoint);

    /**
     * @return Collection
     */
    public function getBreakpoints();

    /**
     * @param Collection $breakpoints
     * @return self
     */
    public function setBreakpoints(Collection $breakpoints);
}
