<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Asset;

use Comitium5\DesignerBundle\Model\Interfaces\IdentifiableInterface;

/**
 * Interface AssetInterface
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Asset
 */
interface AssetInterface extends IdentifiableInterface, AssetMetadataInterface
{
    /**
     * @return string
     */
    public function getType(): string;

    /**
     * @param string $type
     *
     * @return mixed
     */
    public function setType(string $type);

    /**
     * @return string
     */
    public function getTitle(): string;

    /**
     * @param string $title
     *
     * @return mixed
     */
    public function setTitle(string $title);

    /**
     * @return string
     */
    public function getUrl(): string;

    /**
     * @param string $url
     *
     * @return mixed
     */
    public function setUrl(string $url);

    /**
     * @return string
     */
    public function getLocaleCode(): string;

    /**
     * @param string $localeCode
     *
     * @return mixed
     */
    public function setLocaleCode(string $localeCode);

    /**
     * @return array|null
     */
    public function getImageRelated(): ?array;

    /**
     * @param array|null $imageRelated
     *
     * @return mixed
     */
    public function setImageRelated(?array $imageRelated);

    /**
     * @return string
     */
    public function getPath(): string;

    /**
     * @param string $path
     *
     * @return mixed
     */
    public function setPath(string $path);

    /**
     * @return array
     */
    public function getChildren(): array;

    /**
     * @param array $children
     *
     * @return mixed
     */
    public function setChildren(array $children);

    /**
     * @return int
     */
    public function getUsages(): int;

    /**
     * @param int $usages
     *
     * @return mixed
     */
    public function setUsages(int $usages);
}
