<?php

namespace Comitium5\DesignerBundle\Model\Interfaces;

use Comitium5\DesignerBundle\Factory\AbstractFactory;
use Doctrine\Common\Persistence\ObjectRepository;

/**
 * Interface AbstractManagerInterface.
 *
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 */
interface AbstractManagerInterface extends ObjectManagerInterface
{
    /**
     * @param ObjectRepository $repository
     *
     * @return mixed
     */
    public function setRepository(ObjectRepository $repository);

    /**
     * @return mixed
     */
    public function getRepository();

    /**
     * @param AbstractFactory $factory
     *
     * @return mixed
     */
    public function setFactory(AbstractFactory $factory);

    /**
     * @return mixed
     */
    public function getFactory();

    /**
     * @param $data
     *
     * @return mixed
     */
    public function save($data);

    /**
     * @param $data
     *
     * @return mixed
     */
    public function update($data);

    /**
     * @param $data
     *
     * @return mixed
     */
    public function remove($data);

    /**
     * @param $id
     *
     * @return mixed
     */
    public function find($id);
}
