<?php

namespace Comitium5\DesignerBundle\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20210806072249 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE admin_breakpoints (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, type VARCHAR(255) NOT NULL, min_width INT DEFAULT NULL, enabled TINYINT(1) DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE admin_layouts (id INT AUTO_INCREMENT NOT NULL, parent_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, class VARCHAR(255) DEFAULT NULL, color VARCHAR(255) DEFAULT NULL, locked TINYINT(1) DEFAULT \'0\' NOT NULL, linked TINYINT(1) DEFAULT \'0\' NOT NULL, predefined TINYINT(1) DEFAULT \'0\' NOT NULL, css LONGTEXT DEFAULT NULL, creation_date DATETIME NOT NULL, modification_date DATETIME DEFAULT NULL, tmp_id VARCHAR(255) DEFAULT NULL, INDEX IDX_910CF4BD727ACA70 (parent_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE admin_layout_rel_layout (layout_id INT NOT NULL, related_layout_id INT NOT NULL, INDEX IDX_FC67F81B8C22AA1A (layout_id), INDEX IDX_FC67F81B24E3F601 (related_layout_id), PRIMARY KEY(layout_id, related_layout_id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE admin_layout_rel_view (layout_id INT NOT NULL, view_id INT NOT NULL, INDEX IDX_6AB6ABBF8C22AA1A (layout_id), INDEX IDX_6AB6ABBF31518C7 (view_id), PRIMARY KEY(layout_id, view_id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE admin_layout_breakpoints (id INT AUTO_INCREMENT NOT NULL, layout_id INT DEFAULT NULL, breakpoint_id INT DEFAULT NULL, enabled TINYINT(1) NOT NULL, columns DOUBLE PRECISION NOT NULL, INDEX IDX_1162568E8C22AA1A (layout_id), INDEX IDX_1162568ECD306D7A (breakpoint_id), UNIQUE INDEX key_layout_breakpoint (layout_id, breakpoint_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE admin_layout_pages (id INT AUTO_INCREMENT NOT NULL, page_id INT DEFAULT NULL, layout_id INT DEFAULT NULL, position INT NOT NULL, start_at DATETIME DEFAULT NULL, end_at DATETIME DEFAULT NULL, html LONGTEXT DEFAULT NULL COLLATE utf8mb4_unicode_ci, tmp_id VARCHAR(255) DEFAULT NULL, INDEX IDX_D0092F52C4663E4 (page_id), INDEX IDX_D0092F528C22AA1A (layout_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE admin_layout_page_widgets (id INT AUTO_INCREMENT NOT NULL, layout_page_id INT DEFAULT NULL, widget_id INT DEFAULT NULL, position INT NOT NULL, parameters LONGTEXT DEFAULT NULL COLLATE utf8mb4_unicode_ci COMMENT \'(DC2Type:object)\', start_at DATETIME DEFAULT NULL, end_at DATETIME DEFAULT NULL, tmp_id VARCHAR(255) DEFAULT NULL, INDEX IDX_5A75074D7E3A3C76 (layout_page_id), INDEX IDX_5A75074DFBE885E2 (widget_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE cs_core_page (id INT AUTO_INCREMENT NOT NULL, template_id INT DEFAULT NULL, origin_id INT NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, UNIQUE INDEX UNIQ_CB20F01B56A273CC (origin_id), INDEX IDX_CB20F01B5DA0FB8 (template_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE cs_core_page_rel_view (page_id INT NOT NULL, view_id INT NOT NULL, INDEX IDX_3B99302C4663E4 (page_id), INDEX IDX_3B9930231518C7 (view_id), PRIMARY KEY(page_id, view_id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE cs_admin_template (id INT AUTO_INCREMENT NOT NULL, group_id INT DEFAULT NULL, parent_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, description LONGTEXT DEFAULT NULL, type INT NOT NULL, width INT DEFAULT NULL, gutter_width INT DEFAULT NULL, color LONGTEXT DEFAULT NULL, columns INT DEFAULT NULL, enabled TINYINT(1) DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, published_at DATETIME DEFAULT NULL, unPublished_at DATETIME DEFAULT NULL, html LONGTEXT NOT NULL COLLATE utf8mb4_unicode_ci, uuid VARCHAR(255) DEFAULT NULL, position SMALLINT DEFAULT NULL, use_bootstrap_rows TINYINT(1) DEFAULT NULL, tmp_id VARCHAR(255) DEFAULT NULL, INDEX IDX_1754BC31FE54D947 (group_id), INDEX IDX_1754BC31727ACA70 (parent_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE admin_template_rel_layout (template_id INT NOT NULL, layout_id INT NOT NULL, INDEX IDX_B92FB3C15DA0FB8 (template_id), INDEX IDX_B92FB3C18C22AA1A (layout_id), PRIMARY KEY(template_id, layout_id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE admin_template_rel_breakpoint (template_id INT NOT NULL, breakpoint_id INT NOT NULL, INDEX IDX_3CAA15905DA0FB8 (template_id), INDEX IDX_3CAA1590CD306D7A (breakpoint_id), PRIMARY KEY(template_id, breakpoint_id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE admin_template_rel_view (template_id INT NOT NULL, view_id INT NOT NULL, INDEX IDX_AFC00EB45DA0FB8 (template_id), INDEX IDX_AFC00EB431518C7 (view_id), PRIMARY KEY(template_id, view_id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE cs_admin_template_group (id INT AUTO_INCREMENT NOT NULL, parent_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, description LONGTEXT DEFAULT NULL, enabled TINYINT(1) DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, INDEX IDX_A0EFB444727ACA70 (parent_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE cs_core_views (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, content LONGTEXT NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, UNIQUE INDEX unique_name (name), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE cs_admin_widget (id INT AUTO_INCREMENT NOT NULL, group_id INT DEFAULT NULL, title VARCHAR(255) DEFAULT NULL, name VARCHAR(255) NOT NULL, description LONGTEXT DEFAULT NULL, version VARCHAR(255) NOT NULL, type INT NOT NULL, uuid LONGTEXT NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, UNIQUE INDEX UNIQ_9F80B1E15E237E06 (name), INDEX IDX_9F80B1E1FE54D947 (group_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE cs_admin_widget_favorite (widget_id INT NOT NULL, user INT NOT NULL, PRIMARY KEY(widget_id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE cs_admin_widget_group (id INT AUTO_INCREMENT NOT NULL, parent_id INT DEFAULT NULL, name VARCHAR(255) NOT NULL, description LONGTEXT DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME DEFAULT NULL, INDEX IDX_C51082C727ACA70 (parent_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('ALTER TABLE admin_layouts ADD CONSTRAINT FK_910CF4BD727ACA70 FOREIGN KEY (parent_id) REFERENCES admin_layouts (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE admin_layout_rel_layout ADD CONSTRAINT FK_FC67F81B8C22AA1A FOREIGN KEY (layout_id) REFERENCES admin_layouts (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE admin_layout_rel_layout ADD CONSTRAINT FK_FC67F81B24E3F601 FOREIGN KEY (related_layout_id) REFERENCES admin_layouts (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE admin_layout_rel_view ADD CONSTRAINT FK_6AB6ABBF8C22AA1A FOREIGN KEY (layout_id) REFERENCES admin_layouts (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE admin_layout_rel_view ADD CONSTRAINT FK_6AB6ABBF31518C7 FOREIGN KEY (view_id) REFERENCES cs_core_views (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE admin_layout_breakpoints ADD CONSTRAINT FK_1162568E8C22AA1A FOREIGN KEY (layout_id) REFERENCES admin_layouts (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE admin_layout_breakpoints ADD CONSTRAINT FK_1162568ECD306D7A FOREIGN KEY (breakpoint_id) REFERENCES admin_breakpoints (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE admin_layout_pages ADD CONSTRAINT FK_D0092F52C4663E4 FOREIGN KEY (page_id) REFERENCES cs_core_page (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE admin_layout_pages ADD CONSTRAINT FK_D0092F528C22AA1A FOREIGN KEY (layout_id) REFERENCES admin_layouts (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE admin_layout_page_widgets ADD CONSTRAINT FK_5A75074D7E3A3C76 FOREIGN KEY (layout_page_id) REFERENCES admin_layout_pages (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE admin_layout_page_widgets ADD CONSTRAINT FK_5A75074DFBE885E2 FOREIGN KEY (widget_id) REFERENCES cs_admin_widget (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE cs_core_page ADD CONSTRAINT FK_CB20F01B5DA0FB8 FOREIGN KEY (template_id) REFERENCES cs_admin_template (id) ON DELETE SET NULL');
        $this->addSql('ALTER TABLE cs_core_page_rel_view ADD CONSTRAINT FK_3B99302C4663E4 FOREIGN KEY (page_id) REFERENCES cs_core_page (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE cs_core_page_rel_view ADD CONSTRAINT FK_3B9930231518C7 FOREIGN KEY (view_id) REFERENCES cs_core_views (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE cs_admin_template ADD CONSTRAINT FK_1754BC31FE54D947 FOREIGN KEY (group_id) REFERENCES cs_admin_template_group (id) ON DELETE SET NULL');
        $this->addSql('ALTER TABLE cs_admin_template ADD CONSTRAINT FK_1754BC31727ACA70 FOREIGN KEY (parent_id) REFERENCES cs_admin_template (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE admin_template_rel_layout ADD CONSTRAINT FK_B92FB3C15DA0FB8 FOREIGN KEY (template_id) REFERENCES cs_admin_template (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE admin_template_rel_layout ADD CONSTRAINT FK_B92FB3C18C22AA1A FOREIGN KEY (layout_id) REFERENCES admin_layouts (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE admin_template_rel_breakpoint ADD CONSTRAINT FK_3CAA15905DA0FB8 FOREIGN KEY (template_id) REFERENCES cs_admin_template (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE admin_template_rel_breakpoint ADD CONSTRAINT FK_3CAA1590CD306D7A FOREIGN KEY (breakpoint_id) REFERENCES admin_breakpoints (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE admin_template_rel_view ADD CONSTRAINT FK_AFC00EB45DA0FB8 FOREIGN KEY (template_id) REFERENCES cs_admin_template (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE admin_template_rel_view ADD CONSTRAINT FK_AFC00EB431518C7 FOREIGN KEY (view_id) REFERENCES cs_core_views (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE cs_admin_template_group ADD CONSTRAINT FK_A0EFB444727ACA70 FOREIGN KEY (parent_id) REFERENCES cs_admin_template_group (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE cs_admin_widget ADD CONSTRAINT FK_9F80B1E1FE54D947 FOREIGN KEY (group_id) REFERENCES cs_admin_widget_group (id) ON DELETE SET NULL');
        $this->addSql('ALTER TABLE cs_admin_widget_favorite ADD CONSTRAINT FK_1532C64CFBE885E2 FOREIGN KEY (widget_id) REFERENCES cs_admin_widget (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE cs_admin_widget_group ADD CONSTRAINT FK_C51082C727ACA70 FOREIGN KEY (parent_id) REFERENCES cs_admin_widget_group (id) ON DELETE CASCADE');
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE admin_layout_breakpoints DROP FOREIGN KEY FK_1162568ECD306D7A');
        $this->addSql('ALTER TABLE admin_template_rel_breakpoint DROP FOREIGN KEY FK_3CAA1590CD306D7A');
        $this->addSql('ALTER TABLE admin_layouts DROP FOREIGN KEY FK_910CF4BD727ACA70');
        $this->addSql('ALTER TABLE admin_layout_rel_layout DROP FOREIGN KEY FK_FC67F81B8C22AA1A');
        $this->addSql('ALTER TABLE admin_layout_rel_layout DROP FOREIGN KEY FK_FC67F81B24E3F601');
        $this->addSql('ALTER TABLE admin_layout_rel_view DROP FOREIGN KEY FK_6AB6ABBF8C22AA1A');
        $this->addSql('ALTER TABLE admin_layout_breakpoints DROP FOREIGN KEY FK_1162568E8C22AA1A');
        $this->addSql('ALTER TABLE admin_layout_pages DROP FOREIGN KEY FK_D0092F528C22AA1A');
        $this->addSql('ALTER TABLE admin_template_rel_layout DROP FOREIGN KEY FK_B92FB3C18C22AA1A');
        $this->addSql('ALTER TABLE admin_layout_page_widgets DROP FOREIGN KEY FK_5A75074D7E3A3C76');
        $this->addSql('ALTER TABLE admin_layout_pages DROP FOREIGN KEY FK_D0092F52C4663E4');
        $this->addSql('ALTER TABLE cs_core_page_rel_view DROP FOREIGN KEY FK_3B99302C4663E4');
        $this->addSql('ALTER TABLE cs_core_page DROP FOREIGN KEY FK_CB20F01B5DA0FB8');
        $this->addSql('ALTER TABLE cs_admin_template DROP FOREIGN KEY FK_1754BC31727ACA70');
        $this->addSql('ALTER TABLE admin_template_rel_layout DROP FOREIGN KEY FK_B92FB3C15DA0FB8');
        $this->addSql('ALTER TABLE admin_template_rel_breakpoint DROP FOREIGN KEY FK_3CAA15905DA0FB8');
        $this->addSql('ALTER TABLE admin_template_rel_view DROP FOREIGN KEY FK_AFC00EB45DA0FB8');
        $this->addSql('ALTER TABLE cs_admin_template DROP FOREIGN KEY FK_1754BC31FE54D947');
        $this->addSql('ALTER TABLE cs_admin_template_group DROP FOREIGN KEY FK_A0EFB444727ACA70');
        $this->addSql('ALTER TABLE admin_layout_rel_view DROP FOREIGN KEY FK_6AB6ABBF31518C7');
        $this->addSql('ALTER TABLE cs_core_page_rel_view DROP FOREIGN KEY FK_3B9930231518C7');
        $this->addSql('ALTER TABLE admin_template_rel_view DROP FOREIGN KEY FK_AFC00EB431518C7');
        $this->addSql('ALTER TABLE admin_layout_page_widgets DROP FOREIGN KEY FK_5A75074DFBE885E2');
        $this->addSql('ALTER TABLE cs_admin_widget_favorite DROP FOREIGN KEY FK_1532C64CFBE885E2');
        $this->addSql('ALTER TABLE cs_admin_widget DROP FOREIGN KEY FK_9F80B1E1FE54D947');
        $this->addSql('ALTER TABLE cs_admin_widget_group DROP FOREIGN KEY FK_C51082C727ACA70');
        $this->addSql('DROP TABLE admin_breakpoints');
        $this->addSql('DROP TABLE admin_layouts');
        $this->addSql('DROP TABLE admin_layout_rel_layout');
        $this->addSql('DROP TABLE admin_layout_rel_view');
        $this->addSql('DROP TABLE admin_layout_breakpoints');
        $this->addSql('DROP TABLE admin_layout_pages');
        $this->addSql('DROP TABLE admin_layout_page_widgets');
        $this->addSql('DROP TABLE cs_core_page');
        $this->addSql('DROP TABLE cs_core_page_rel_view');
        $this->addSql('DROP TABLE cs_admin_template');
        $this->addSql('DROP TABLE admin_template_rel_layout');
        $this->addSql('DROP TABLE admin_template_rel_breakpoint');
        $this->addSql('DROP TABLE admin_template_rel_view');
        $this->addSql('DROP TABLE cs_admin_template_group');
        $this->addSql('DROP TABLE cs_core_views');
        $this->addSql('DROP TABLE cs_admin_widget');
        $this->addSql('DROP TABLE cs_admin_widget_favorite');
        $this->addSql('DROP TABLE cs_admin_widget_group');
    }
}
