<?php

namespace Comitium5\DesignerBundle\Manager\Layout;

use Comitium5\DesignerBundle\Factory\AbstractFactory;
use Comitium5\DesignerBundle\Helper\Utils;
use Comitium5\DesignerBundle\Manager\AbstractManager;
use Comitium5\DesignerBundle\Manager\Page\PageManager;
use Comitium5\DesignerBundle\Model\Interfaces\Layout\LayoutPageInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\Common\Persistence\ObjectRepository;

/**
 * Class LayoutPageManager
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Manager\Layout
 */
class LayoutPageManager extends AbstractManager
{
    /**
     * @var LayoutPageWidgetManager
     */
    private $layoutPageWidgetManager;

    /**
     * @param AbstractFactory $factory
     * @param ObjectRepository $repository
     * @param ObjectManager $objectManager
     * @param LayoutPageWidgetManager $layoutPageWidgetManager
     */
    public function __construct(
        AbstractFactory $factory,
        ObjectRepository $repository,
        ObjectManager $objectManager,
        LayoutPageWidgetManager $layoutPageWidgetManager
    ) {
        $this->factory = $factory;
        $this->repository = $repository;
        $this->objectManager = $objectManager;
        $this->layoutPageWidgetManager = $layoutPageWidgetManager;
    }

    /**
     * @param mixed $data
     * @param LayoutManager $layoutManager
     * @param PageManager $pageManager
     * @return LayoutPageInterface
     */
    public function fromArray($data, LayoutManager $layoutManager, PageManager $pageManager)
    {
        try {
            $layoutPage = $this->find(
                !empty($data['id']) ? $data['id'] : 0
            );
        } catch (\Exception $e) {
            $layoutPage = $this->getFactory()->create();
        }

        $dateFields = array('startAt', 'endAt');
        $specificFields = array('page', 'layout', 'layoutPageWidgets');
        foreach (array_merge($specificFields, $dateFields) as $field) {
            if (isset($data[$field])) {
                if (in_array($field, $dateFields)) {
                    $data[$field] = Utils::getDateTime($data[$field]);
                } else {
                    $$field = $data[$field];
                    unset($data[$field]);
                }
            }
        }

        $layoutPage->fromArray($data);
        if (!empty($page)) {
            $entity = $pageManager
                ->fromArray($page);
            $layoutPage->setPage($entity);
        }
        if (!empty($layout)) {
            $entity = $layoutManager
                ->fromArray($layout);
            $layoutPageWidget->setLayout($entity);
        }
        if (isset($layoutPageWidgets)) {
            foreach ($layoutPageWidgets as $layoutPageWidgetData) {
                $layoutPageWidget = $this->layoutPageWidgetManager
                    ->fromArray(
                        $layoutPageWidgetData,
                        $this,
                        $layoutManager,
                        $pageManager
                    );
                $layoutPage->addLayoutPageWidget($layoutPageWidget);
            }
        }

        return $layoutPage;
    }

    /**
     * @param  LayoutPageInterface $item
     * @return LayoutPageInterface
     */
    public function cloneItem($item)
    {
        $entity = clone $item;

        $this->cloneHandler($entity, $item);
        $entity->setLayout(null);
        $entity->setPage(null);

        foreach ($item->getLayoutPageWidgets() as $layoutPageWidgetData) {
            $layoutPageWidget = $this->layoutPageWidgetManager
                ->cloneItem($layoutPageWidgetData);
            $entity->addLayoutPageWidget($layoutPageWidget);
        }

        return $entity;
    }
}
