<?php

namespace Comitium5\DesignerBundle\Helper;

/**
 * Class MultiServerHelper
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Helper
 */
class MultiServerHelper
{
    const USE_CASE_PAGE   = 'pages';
    const USE_CASE_ASSET  = 'assets';
    const USE_CASE_WIDGET = 'widgets';
    const USE_CASE_BACK_CACHE  = 'back-cache';
    const USE_CASE_ROUTING  = 'routing';

    /**
     * @var string
     */
    private $rootPath;

    /**
     * MultiServerHelper constructor.
     *
     * @param $rootPath
     */
    public function __construct($rootPath) {
        $this->rootPath = $rootPath;
    }

    /**
     * @param $frontPath
     * @param $useCase
     * @param string $widgetName
     * @param string $subSiteId
     *
     * @return string
     */
    public function buildExecutionLine($frontPath, $useCase, $widgetName = "''", $subSiteId = "''")
    {
        return sprintf($this->rootPath.DIRECTORY_SEPARATOR."bin".DIRECTORY_SEPARATOR."multi-servers-commands.sh %s %s %s %s",
            $frontPath,
            $useCase,
            $widgetName,
            $subSiteId
        );
    }
}
