<?php

namespace Comitium5\DesignerBundle\Helper\CKEditor;

/**
 * Class CkAssetHelper
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Helper\CKEditor
 */
class CkAssetHelper
{
    /**
     * @param string $backEndUrl
     * @param string $locale
     * @param int $assetId
     *
     * @return string
     */
    public static function prepareEditUrl(string $backEndUrl, string $locale, int $assetId, string $userToken): string
    {
        return sprintf(
            "%s/%s/private/assets/edit/%s?ignoreReferer=1&cs-designer-token=%s",
            $backEndUrl,
            $locale,
            $assetId,
            $userToken
        );
    }
}
