<?php

namespace Comitium5\DesignerBundle\Form\Type\Template;

use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * Class TemplateType
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Form\Type\Template
 */
class TemplateType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array                $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'label' => 'admin_template.create.form.label.name',
                'attr' => [
                    'maxLength' => 255,
                ],
            ])
            ->add('description', TextareaType::class, [
                'label' => 'admin_template.create.form.label.description',
                'required' => false,
                'attr' => [
                    'rows' => '4',
                ],
            ])
//            ->add('color', TextType::class, [
//                'label' => 'admin_template.create.form.label.color',
//                'required' => false,
//                'attr' => [
//                    'class' => 'colorpicker-default',
//                ],
//            ])
            ->add('enabled', CheckboxType::class, [
                'label' => 'admin_template.create.form.label.enabled',
                'required' => false,
            ])
//            ->add('useBootstrapRows', CheckboxType::class, [
//                'label' => 'admin_template.create.form.label.useBootstrapRows',
//                'required' => false,
//            ])
            ->add('parent', EntityType::class, [
//                'label' => 'admin_template.create.form.label.parent',
                'required' => false,
                'class' => $options['data_class'],
//                'placeholder' => 'admin_template.create.form.placeholder.parent',
                'choice_label' => 'name',
            ])
//            ->add('width', TextType::class, [
//                'required' => false,
//                'label' => 'admin_template.create.form.label.width',
//                'help' => 'admin_template.create.form.help.width',
//            ])
//            ->add('gutterWidth', TextType::class, [
//                'required' => true,
//                'label' => 'admin_template.create.form.label.gutterWidth',
//                'help' => 'admin_template.create.form.help.gutterWidth',
//            ])
//            ->add('columns', TextType::class, [
//                'required' => true,
//                'label' => 'admin_template.create.form.label.columns',
//                'help' => 'admin_template.create.form.help.columns',
//            ])
            ->add('html', TextareaType::class, [
//                'label' => 'admin_template.create.form.label.code',
                'attr' => [],
            ])
            ->add('breakpoints', EntityType::class, [
                'class' => 'Comitium5\DesignerBundle\Entity\Breakpoint',
                'expanded' => false,
                'multiple' => true,
                'required' => false,
                'choice_label' => 'name',
            ])
            ->add('submit', SubmitType::class, ['label' => 'cs_admin.designer.toolbar.save'])
        ;
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver
            ->setDefaults([
                "unique" => true,
            ]);
    }

    /**
     * @return string
     */
    public function getBlockPrefix()
    {
        return 'admin_template';
    }
}
