<?php

namespace Comitium5\DesignerBundle\Form\Type\Suggest;

use Comitium5\ApiClientBundle\Client\ClientInterface;
use Comitium5\DesignerBundle\Form\DataTransformer\SuggestDataTransformer;
use Symfony\Bundle\FrameworkBundle\Routing\Router;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Routing\RouterInterface;

/**
 * Class SuggestType
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\DesignerBundle\Form\Type\Suggest
 */
class SuggestType extends AbstractType
{
    /**
     * @var ClientInterface
     */
    private $apiService;

    /**
     * @var RouterInterface
     */
    private $router;

    /**
     * SuggestType constructor.
     *
     * @param ClientInterface $apiService
     * @param RouterInterface $router
     */
    public function __construct(
        ClientInterface $apiService,
        RouterInterface $router
    ) {
        $this->apiService = $apiService;
        $this->router = $router;
    }

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $transformer = new SuggestDataTransformer($this->apiService);

        $builder
            ->addViewTransformer(
                $transformer
                    ->setSeparator($options['separator'])
                    ->setContentType($options['content_type'])
                    ->setProperty($options['property'])
                    ->setMultiple($options['multiple'])
                    ->setLabelProperties($options['labelProperties'])
            );
    }

    /**
     * @param FormView $view
     * @param FormInterface $form
     * @param array $options
     */
    public function buildView(FormView $view, FormInterface $form, array $options): void
    {
        $view->vars['url'] = $this
            ->router
            ->generate(
                $options['route'],
                [],
                Router::ABSOLUTE_URL
            );

        if ($options['id'] !== null) {
            $view->vars['id'] = $options['id'];
        }

        $view->vars['separator'] = $options['separator'];
        $view->vars['property'] = $options['property'];
        $view->vars['allow_clear'] = $options['allow_clear'];
        $view->vars['limit'] = $options['limit'];
        $view->vars['multiple'] = $options['multiple'];
        $view->vars['dropdownCssClass'] = $options['dropdownCssClass'];
        $view->vars['autoInitialize'] = $options['autoInitialize'];
        $view->vars['labelProperties'] = $options['labelProperties'];
        $view->vars['onlyPublished'] = intval($options['onlyPublished']);
        $view->vars['content_type'] = $options['content_type'];
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver
            ->setRequired([
                'route',
                'property',
                'content_type',
            ])
            ->setDefined([
                'allow_create',
                'allow_clear',
                'multiple',
                'limit',
                'dropdownCssClass',
                'autoInitialize',
                'labelProperties',
                'onlyPublished',
                'data_class',
            ])
            ->setDefaults([
                'route'            => 'designer_suggest',
                'property'         => 'title',
                'content_type'     => null,
                'allow_create'     => false,
                'allow_clear'      => 1,
                'id'               => null,
                'multiple'         => false,
                'limit'            => 10,
                'autoInitialize'   => 'true',
                'dropdownCssClass' => '',
                'labelProperties'  => '',
                'onlyPublished'    => false,
                'separator'        => ',',
                'data_class'       => null,
            ]);
    }

    /**
     * @return string
     */
    public function getParent(): string
    {
        return TextType::class;
    }

    /**
     * @return string
     */
    public function getBlockPrefix(): string
    {
        return 'suggest';
    }
}
