<?php

namespace Comitium5\DesignerBundle\Form\Type;

use Comitium5\ApiClientBundle\Client\ClientInterface;
use Comitium5\ApiClientBundle\Client\Services\AssetApiService;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;
use Comitium5\DesignerBundle\Factory\Asset\AssetFactory;
use Comitium5\DesignerBundle\Factory\NormalizerFactory;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\FormType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * Class AssetType
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Form\Type
 */
class AssetType extends AbstractType
{
    /**
     * @var ClientInterface
     */
    private $apiClient;

    /**
     * AssetType constructor.
     *
     * @param $apiClient
     */
    public function __construct(ClientInterface$apiClient)
    {
        $this->apiClient = $apiClient;
    }

    /**
     * {@inheritdoc}
     */
    public function buildView(FormView $view, FormInterface $form, array $options)
    {
        $view->vars['multiple'] = $options['multiple'];
        $view->vars['asset_type'] = $options['asset_type'];

        if ($options['multiple']) {
            $view->vars['full_name'] .= '[]';
            $view->vars['id'] = false;
        }

        if (is_null($options['label']) && false !== $options['label']) {
            $view->vars['label'] = 'cs_core.label.'.($options['asset_type'] ?: 'asset').'.'.($options['multiple'] ? 'multiple' : 'singular');
        }

        if ($parent = $form->getParent()) {
            while ($parent->getParent() != null) {
                $parent = $parent->getParent();
            }
        } else {
            $parent = $form;
        }

        $_options = $parent->getConfig()->getOptions();

        $view->vars = array_replace($view->vars, array(
            'type' => HiddenType::class,
        ));

        $view->vars['parent_type'] = null;

        $formOptions = $parent->getConfig()->getOptions();
        $view->vars['content_type'] = isset($formOptions['content_type']) ? $formOptions['content_type'] : null;

        if (preg_match("/(\\w+)$/", $_options['data_class'], $matches)) {
            $view->vars['parent_type'] = strtolower($matches[0]);
        }

        $data = $form->getData();

        if (is_numeric($data)) {
            $normalizerFactory = new NormalizerFactory(
                new AssetApiService($this->apiClient),
                new AssetFactory()
            );

            $view->vars['entityData'] = $normalizerFactory->create(new IdentifiedValue($data));
        }
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver
            ->setDefaults([
                'compound' => false,
                'empty_data' => null,
                'multiple' => false,
                'asset_type' => null,
                'allow_extra_fields' => true,
            ]);
    }

    /**
     * @return string
     */
    public function getParent()
    {
        return FormType::class;
    }

    /**
     * @return string
     */
    public function getBlockPrefix()
    {
        return 'asset';
    }
}
