<?php

namespace Comitium5\DesignerBundle\Factory\Widget;

use Comitium5\DesignerBundle\Factory\AbstractFactory;
use Comitium5\DesignerBundle\Model\Interfaces\GeneratorProviderInterface;
use Comitium5\DesignerBundle\Model\WidgetType;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class WidgetFactory
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Factory\Widget
 */
class WidgetFactory extends AbstractFactory
{
    /**
     * @var GeneratorProviderInterface
     */
    private $generator;

    /**
     * WidgetFactory constructor.
     * @param GeneratorProviderInterface $generator
     */
    public function __construct(GeneratorProviderInterface $generator)
    {
        $this->generator = $generator;
    }

    /**
     * @return mixed
     */
    public function create()
    {
        $classNamespace = $this->getEntityNamespace();

        $widget = new $classNamespace();
        $widget->setCreatedAt(new \DateTime('NOW'));
        $widget->setUpdatedAt(new \DateTime('NOW'));
        $widget->setType(WidgetType::DYNAMIC);
        $widget->setVersion('1.0');
        $widget->setUuid($this->generator->generateUid());
        $widget->setOptions(new ArrayCollection());

        return $widget;
    }
}
