<?php

namespace Comitium5\DesignerBundle\Factory\Template;


use Comitium5\DesignerBundle\Factory\AbstractFactory;
use Comitium5\DesignerBundle\Helper\Utils;
use Comitium5\DesignerBundle\Model\TemplateTypes;

/**
 * Class TemplateFactory.
 *
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 */
class TemplateFactory extends AbstractFactory
{
    const TEMPLATE_CODE_BASE = '{% block cscontent %}{% endblock %}';
    /**
     * @return mixed
     */
    public function create()
    {
        $classNamespace = $this->getEntityNamespace();

        $template = new $classNamespace();
        $template->setCreatedAt(new \DateTime('NOW'));
        $template->setEnabled(true);
        $template->setType(TemplateTypes::TEMPLATE);
        $template->setGutterWidth(30);
        $template->setWidth(1024);
        $template->setColumns(12);
        $template->setUuid(Utils::uuidV4());
        $template->setUseBootstrapRows(true);

        $templateCodeBase = self::TEMPLATE_CODE_BASE;

        $template->setHtml($templateCodeBase);

        return $template;
    }
}
