<?php

namespace Comitium5\DesignerBundle\Factory\Search\Filter;

use Elastica\Query\BoolQuery;
use Elastica\Query\Match;

/**
 * Class LocaleShouldFilter
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Factory\Search\Filter
 */
class LocaleShouldFilter
{
    /**
     * @var string
     */
    private $localeCode;

    /**
     * LocaleFilter constructor.
     *
     * @param string $localeCode
     */
    public function __construct(string $localeCode)
    {
        $this->localeCode = $localeCode;
    }

    /**
     * @param BoolQuery $boolQuery
     */
    public function __invoke(BoolQuery $boolQuery): void
    {
        $match = new Match();

        $match->setFieldQuery('locale.code', $this->localeCode);

        $this->addFilter($boolQuery, $match);
    }

    /**
     * @param BoolQuery $boolQuery
     * @param Match $match
     */
    protected function addFilter(BoolQuery $boolQuery, Match $match): void
    {
        $boolQuery->addShould($match);
    }
}
