<?php

namespace Comitium5\DesignerBundle\Factory;

use Comitium5\DesignerBundle\Model\Interfaces\AbstractFactoryInterface;

/**
 * Class AbstractFactory
 *
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 * @author Fernando Pradas <developer@fernandopradas.com>
 */
abstract class AbstractFactory implements AbstractFactoryInterface
{
    /**
     * @var string
     *
     * Entity namespace
     */
    protected $entityNamespace;

    /**
     * @inheritDoc
     */
    public function setEntityNamespace($entityNamespace)
    {
        $this->entityNamespace = $entityNamespace;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getEntityNamespace()
    {
        return $this->entityNamespace;
    }


}
