<?php

namespace Comitium5\DesignerBundle\Entity;

use Comitium5\DesignerBundle\Model\Interfaces\Site\SiteInterface;
use Comitium5\DesignerBundle\Model\Traits\IdentifiableTrait;

/**
 * Class Site
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Entity
 */
class Site implements SiteInterface
{
    use IdentifiableTrait;

    /**
     * @var string
     */
    private $prefix;

    /**
     * @return string
     */
    public function getPrefix()
    {
        return $this->prefix;
    }

    /**
     * @param string $prefix
     *
     * @return $this|Site
     */
    public function setPrefix($prefix)
    {
        $this->prefix = $prefix;

        return $this;
    }
}
