<?php

namespace Comitium5\DesignerBundle\DataFixtures\ORM\Breakpoint;

use Comitium5\DesignerBundle\DataFixtures\Abstracts\AbstractFixture;
use Doctrine\Common\Persistence\ObjectManager;

/**
 * Class BreakpointFixtures.
 *
 * @author Sergio de Candelario <sergio@bab-soft.com>
 */
class BreakpointFixtures extends AbstractFixture
{
    /**
     * Load data fixtures with the passed EntityManager.
     *
     * @param ObjectManager $manager
     */
    public function load(ObjectManager $manager)
    {
        $factory = $this
            ->container
            ->get('designer.factory.breakpoint');

        foreach ($this->breakpoints() as $input) {
            $breakpoint = $factory->create();

            $breakpoint->setName($input['name']);
            $breakpoint->setMinWidth($input['minWidth']);
            $breakpoint->setType($input['type']);

            $this->setReference($input["reference"], $breakpoint);

            $manager->persist($breakpoint);
        }

        $manager->flush();
    }

    /**
     * @return array[]
     */
    private function breakpoints(): array
    {
        return [
            [
                'name' => 'XS',
                'type' => 'xs',
                'minWidth' => 650,
                'maxWidth' => null,
                'enabled' => true,
                'reference' => 'breakpoint-xs',
            ],
            [
                'name' => 'SM',
                'type' => 'sm',
                'minWidth' => 768,
                'maxWidth' => null,
                'enabled' => true,
                'reference' => 'breakpoint-sm',
            ],
            [
                'name' => 'MD',
                'type' => 'md',
                'minWidth' => 960,
                'maxWidth' => null,
                'enabled' => true,
                'reference' => 'breakpoint-md',
            ],
            [
                'name' => 'LG',
                'type' => 'lg',
                'minWidth' => 1300,
                'maxWidth' => null,
                'enabled' => true,
                'reference' => 'breakpoint-lg',
            ],
        ];
    }
}
