<?php

namespace Comitium5\DesignerBundle\Controller\Search\Suggest;

use Comitium5\DesignerBundle\Factory\Search\Suggest\SearchQueryObjectFactory;
use Comitium5\DesignerBundle\UseCase\Search\SuggestSearchUseCase;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class SuggestController
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\DesignerBundle\Controller\Search\Suggest
 */
class SuggestController extends Controller
{
    /**
     * @param Request $request
     *
     * @return JsonResponse
     * @throws \Exception
     */
    public function __invoke(Request $request): JsonResponse
    {
        $useCase = new SuggestSearchUseCase(
            $this->get('designer.repository.search'),
            SearchQueryObjectFactory::create(
                $request,
                $this->get('designer.provider.locale'),
                [$this->get('designer.provider.subsite')->getSubsite()]
            ),
            $request->get('labelProperties'),
            $request->get('property')
        );

        return $useCase();
    }
}