<?php

namespace Comitium5\DesignerBundle\Controller\Breakpoint;

use Comitium5\DesignerBundle\Controller\CRUDController;
use Comitium5\DesignerBundle\Form\Type\Breakpoint\BreakpointType;
use Symfony\Component\HttpFoundation\Request;
use Comitium5\DesignerBundle\Entity\Breakpoint;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class BreakpointController
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Controller\Breakpoint
 */
class BreakpointController extends CRUDController
{
    /**
     * @param Request $request
     *
     * @return mixed|\Symfony\Component\HttpFoundation\Response
     * @throws \Exception
     */
    public function listAction(Request $request)
    {
        $this->checkRequest($request);

        $builder = $this->get('designer.manager.search.search_list')->handleSimpleSearch(
            $this->get('designer.repository.breakpoint'),
            $request
        );


        $pagination = $this->paginate($request, $builder);

        return $this->render('Comitium5DesignerBundle:Breakpoint:index.html.twig', array(
            'pagination' => $pagination,
        ));
    }

    /**
     * @param Request $request
     *
     * @return BreakpointController|mixed|\Symfony\Component\HttpFoundation\RedirectResponse|Response
     * @throws \Doctrine\ORM\ORMException
     */
    //TODO add correct translations and routing
    public function createAction(Request $request)
    {
        $manager = $this->get('designer.manager.breakpoint');

        $entity = $manager->getFactory()->create();

        $form = $this->createForm(BreakpointType::class, $entity, array(
            'method' => Request::METHOD_POST,
            'validation_groups' => 'new',
            'data_class' => $manager->getFactory()->getEntityNamespace(),
        ));

        $form->handleRequest($request);

        if ($form->isValid()) {
            $manager->save($entity);

            $this->addToastrMessage('success', 'admin_breakpoint.create.messages.success.create');

            return $this->handleFormRedirect($form, $this->generateUrl('designer_breakpoint_index'));
        }

        return $this->render('Comitium5DesignerBundle:Breakpoint:form.html.twig', array(
            'entity' => $entity,
            'form' => $form->createView(),
//            'page_title' => $this->get('translator')->trans('admin_breakpoint.create.title'),
        ));
    }
    /**
     * @param Request $request
     * @param Breakpoint|null $entity
     *
     * @return BreakpointController|mixed|\Symfony\Component\HttpFoundation\RedirectResponse|Response
     * @throws \Doctrine\ORM\ORMException
     */
    //TODO add correct translations and routing
    public function editAction(Request $request, Breakpoint $entity = null)
    {
        $this->handleIfNotFound($entity);

        $manager = $this->get('designer.manager.breakpoint');

        $form = $this->createForm(BreakpointType::class, $entity, array(
            'method' => Request::METHOD_POST,
            'validation_groups' => 'edit',
            'data_class' => $manager->getFactory()->getEntityNamespace(),
        ));

        $form->handleRequest($request);

        if ($form->isValid()) {
            $manager->update($entity);

            $this->addToastrMessage('success', 'admin_breakpoint.create.messages.success.edit');

            return $this->handleFormRedirect($form, $this->generateUrl('designer_breakpoint_index'));
        }

        return $this->render('Comitium5DesignerBundle:Breakpoint:form.html.twig', array(
            'entity' => $entity,
            'form' => $form->createView(),
            'page_title' => $this->get('translator')->trans('admin_breakpoint.edit.title'),
        ));
    }

    /**
     * @param Request $request
     * @param Breakpoint|null $entity
     *
     * @return mixed|\Symfony\Component\HttpFoundation\RedirectResponse|Response
     */
    //TODO add correct translations and routing
    public function deleteAction(Request $request, Breakpoint $entity = null)
    {
        $this->handleIfNotFound($entity);

        if ($request->isMethod(Request::METHOD_GET)) {
            return new Response();
        }

        if (!$entity) {
            return $this->redirectToRoute('designer_breakpoint_index');
        }

        $this->get('designer.manager.breakpoint')->remove($entity);

        $this->addToastrMessage('success', 'admin_breakpoint.create.messages.success.delete');

        return $this->redirectToRoute('designer_breakpoint_index');
    }
}
