<?php

namespace Comitium5\DesignerBundle\Controller\Asset;

use Comitium5\ApiClientBundle\Client\Services\AssetApiService;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;
use Comitium5\DesignerBundle\Normalizer\Api\Asset\AssetImageRelatedNormalizer;
use Comitium5\DesignerBundle\Normalizer\Api\Asset\AssetTitlesNormalizer;
use Comitium5\DesignerBundle\UseCase\Asset\DeleteAssetUseCase;
use Comitium5\DesignerBundle\UseCase\Asset\SearchAssetUseCase;
use Comitium5\DesignerBundle\UseCase\Asset\UpdateAssetUseCase;
use Comitium5\DesignerBundle\ValueObjects\Asset\SearchAssetObject;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class AssetController
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Controller\Asset
 */
class AssetController extends Controller
{
    /**
     * @param Request $request
     *
     * @return Response|null
     * @throws \GuzzleHttp\Exception\GuzzleException|\Exception
     */
    public function searchAction(Request $request)
    {
        $type = $request->attributes->get('type', null);

        $assetApiService = new AssetApiService($this->get("designer.api"));

        $searchAssetUseCase = new SearchAssetUseCase();

        $pagination = $searchAssetUseCase(
            $assetApiService,
            $this->get("designer.knp_paginator"),
            new SearchAssetObject(
                $request->query->get('search', null),
                $type,
                $request->query->get('page', 1)
            ),
            [
                new AssetImageRelatedNormalizer($assetApiService),
                new AssetTitlesNormalizer(
                    $this->get("designer.builder.api_locale"),
                    $this->get("designer.provider.locale")
                ),
            ]
        );

        return $this->render('Comitium5DesignerBundle:Asset:page_library.html.twig', array(
            'pagination' => $pagination->getPagination(),
            'type' => $type,
        ));
    }

    /**
     * @param Request $request
     *
     * @return Response
     */
    public function uploadAction(Request $request)
    {
        return JsonResponse::create('OK');
    }

    /**
     * @param Request $request
     *
     * @return array|JsonResponse
     * @throws \Exception
     */
    public function updateTitleAction(Request $request): JsonResponse
    {
        $apiClient = $this
            ->get("designer.builder.api_locale")(
                $request->request->get('locale')
            );

        $updateUseCase = new UpdateAssetUseCase(new AssetApiService($apiClient));

        $response = $updateUseCase(new IdentifiedValue($request->request->get('id')), new ParametersValue([
            "defaultLang" => [
                "title" => $request->request->get('title'),
            ],
        ]));

        return JsonResponse::create([
            'status' => empty($response) ? JsonResponse::HTTP_NOT_FOUND : JsonResponse::HTTP_OK,
        ]);
    }

    /**
     * @param Request $request
     *
     * @return JsonResponse
     * @throws \Exception
     */
    public function deleteAction(Request $request): JsonResponse
    {
        $deleteAssetUseCase = new DeleteAssetUseCase(new AssetApiService($this->get("designer.api")));

        $hasDeleted = $deleteAssetUseCase(new IdentifiedValue($request->get('ids')));

        return JsonResponse::create(array(
            'status' => $hasDeleted ? Response::HTTP_OK : Response::HTTP_BAD_REQUEST,
        ));
    }

    /**
     * @param Request $request
     *
     * @return Response
     */
    public function browseAction(Request $request)
    {
        return new Response(<<<HTML
<center>
<h2>This is the default browse files page for Comitium Suite</h2>
</center>
HTML
        );
    }
}
