<?php

namespace Comitium5\DesignerBundle\Adapter\Search;

use Comitium5\DesignerBundle\Model\Interfaces\SearchClientInterface;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\DBALException;
use Doctrine\DBAL\DriverManager;

/**
 * Class ExternalDbClient
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\DesignerBundle\Adapter\Search
 */
class ExternalDbClient implements SearchClientInterface
{
    /**
     * @var Connection
     */
    private $client;

    /**
     * ExternalDbClient constructor.
     *
     * @param string $connectionString
     *
     * @throws DBALException
     */
    public function __construct(string $connectionString)
    {
        $this->client = DriverManager::getConnection(["url" => $connectionString]);

        if (!$this->client) {
            throw new \Exception("Invalid connection instance");
        }
    }

    /**
     * @return Connection
     */
    public function getClient(): Connection
    {
        return $this->client;
    }
}