var ShortcutsManager = Class.extend({
    init: function() {
        this.item = null;
        this.clippboard = null;
        this.x = null;
        this.y = null;
    },
    initKeyboard: function() {
        var $this = this;
        $this.item.on('keydown', function(event) {
            $this.manageKeys(event);
        }).on('mousemove', function(event){
            $this.x = event.pageX;
            $this.y = event.pageY;
        });

        return this;
    },
    copy: function() {
        var currentElementPointer = this.item.get(0).elementFromPoint(this.x, this.y),
            layout = $(currentElementPointer).closest('cslayout');

        if(layout.length > 0) {
            this._copy(layout);
        }

        return this;
    },
    _copy: function(layout) {
        var widgetsOfLayout = $(Widget.TAG, layout).length;
        if(widgetsOfLayout > 0) {
            toastr.success(Translator.trans('cs_admin.designer.toastr.success.copy'));
            this.clippboard = {
                'action': ShortcutsManager.ACTIONS.COPY,
                'layout': layout
            };
        } else {
            toastr.warning(Translator.trans('cs_admin.designer.toastr.alert.copyNoContent'));
        }
    },
    cut: function() {
        var currentElementPointer = this.item.get(0).elementFromPoint(this.x, this.y),
            layout = $(currentElementPointer).closest('cslayout');

        if(layout.length > 0) {
            this._cut(layout);
        }

        return this;
    },
    _cut: function(layout) {
        var widgetsOfLayout = $(Widget.TAG, layout).length;
        if(widgetsOfLayout > 0) {
            toastr.success(Translator.trans('cs_admin.designer.toastr.success.cut'));
            this.clippboard = {
                'action' : ShortcutsManager.ACTIONS.CUT,
                'layout' : layout
            };
        } else {
            toastr.warning(Translator.trans('cs_admin.designer.toastr.alert.cutNoContent'));
        }

    },
    paste: function() {
        if(!$.isEmptyObject(this.clippboard)) {
            var currentElementPointer = this.item.get(0).elementFromPoint(this.x, this.y),
                layout = $(currentElementPointer).closest('cslayout'),
                layoutObject = layout.data('object');

            if (layout.length > 0 && !layoutObject.blocked && $(Layout.TAG, layout).length === 0) {
                this._paste(layout);
            } else {
                toastr.warning('not a layout!');
            }
        }

        return this;
    },
    _paste: function(layout) {
        if(this.clippboard !== null) {
            var widgets = this.getContentsOfLayout(this.clippboard.layout),
                widgetsLength = widgets.length,
                layoutObject = layout.data('object');

            if(widgetsLength > 0) {
                toastr.success(Translator.trans('cs_admin.designer.toastr.success.paste'));

                for(var i = 0; i < widgetsLength; i++) {
                    var newWidget = widgets[i].clone(layoutObject);
                    jQuery('.'+Layout.CONTENT_CLASS+':first', layoutObject.getTarget()).append(newWidget.render());
                    newWidget.createDOMNode('#'+newWidget.uniqueId, false);
                    newWidget.layout.template.widgetsStorage.add(newWidget);

                    if(CSTemplate.mode = Template.CONTENT_MODE) {
                        newWidget.enable();
                        newWidget.getTarget().trigger(Widget.LOAD_CKEDITOR_EVENT);
                    } else {
                        newWidget.disable();
                    }

                    if(this.clippboard.action === ShortcutsManager.ACTIONS.CUT) {
                        widgets[i].remove();
                    }
                }

                layoutObject.update(true);
            }

            this.clippboard = null;
        } else {
            toastr.warning(Translator.trans('cs_admin.designer.toastr.alert.pasteNoContent'));
        }
    },
    setItem: function(item) {
        this.item = $(item.get(0).ownerDocument);

        return this;
    },
    manageKeys: function(event) {
        //var $this = this,
        //    //metaKey for mac compatibility
        //    ctrlDown = event.ctrlKey || event.metaKey;
        //
        //if(ctrlDown) {
        //    switch(event.keyCode) {
        //        case ShortcutsManager.KEYS.COPY:
        //            $this.copy();
        //            break;
        //        case ShortcutsManager.KEYS.CUT:
        //            $this.cut();
        //            break;
        //        case ShortcutsManager.KEYS.PASTE:
        //            $this.paste();
        //            break;
        //        default:
        //            break;
        //    }
        //}
    },
    getContentsOfLayout: function(layout) {
        var widgetElements = [];
        $(Widget.TAG, layout).each(function(){
            widgetElements.push($(this).data('object'));
        });

        return widgetElements;
    }
});

ShortcutsManager.ACTIONS = {
    'CUT' : 'cut',
    'COPY' : 'copy',
    'PASTE': 'paste'
};

ShortcutsManager.KEYS = {
    'COPY': 67,
    'CUT': 88,
    'PASTE': 86
};