/**
 *
 * @constructor
 */
var DeleteContentActivity = function() {
    var _this = this;

    this.selector = '[data-toggle="modal"][data-behaviour="delete"]';
    this.url = '';
    this.module = null;

    this.signals = {
        check: new signals.Signal(),
        confirm: new signals.Signal(),
        remove: new signals.Signal(),
        success: new signals.Signal()
    };

    this.functions = {
        checkDeletion: function(params) {

            var d = Q.defer();

            _this.signals.check.dispatch(d, params);

            if(d.promise.isPending() || !params.managed) {
                $.get(params.url)
                    .success(function (data, status, jqXHR) {
                        if (data) {
                            if (data.title) {
                                params.title = data.title;
                            }

                            if (data.message) {
                                params.message = data.message;
                            }
                        }

                        d.resolve(params);
                    })
                    .fail(function (jqXHR) {

                        var _error;

                        if(jqXHR.hasOwnProperty('responseJSON')) {
                            _error = new Error(Translator.trans(jqXHR.responseJSON.message));

                            if(jqXHR.responseJSON.hasOwnProperty('title')) {
                                _error.title = Translator.trans(jqXHR.responseJSON.title);
                            }

                        } else {
                            _error = new Error(Translator.trans(jqXHR.responseText));
                        }

                        d.reject(_error);
                    });

            }

            return d.promise;
        },
        confirmDeletion: function(params) {
            var d = Q.defer();
            _this.signals.confirm.dispatch(d, params);

            if(d.promise.isPending() || !params.managed) {

                var title   = params.title   ? params.title : Translator.trans("designer_common.delete_entity");
                var message = params.message ? params.message : Translator.trans("designer_common.messages.confirm_delete");

                var modal = window.bootstrap.modal.show(title, message, Translator.trans("designer_common.action.accept"));

                modal.find('[data-btn-type="save"]').on("click", function () {
                    d.resolve(params);
                });
            }

            return d.promise;
        },
        deleteEntity: function(params) {
            var d = Q.defer();
            _this.signals.remove.dispatch(d, params);

            if(d.promise.isPending() || !params.managed) {
                $.post(params.url, params.postParams)
                .success(function (response) {
                    d.resolve(params);
                })
                .fail(function (jqXHR) {
                    d.reject(new Error(jqXHR.responseText));
                });
            }

            return d.promise;
        },
        onSuccess: function(params) {
            _this.signals.success.dispatch(params);

            if(!params.managed) {
                if (params.redirectUrl) {
                    window.location = params.redirectUrl;
                } else {
                    window.location.reload();
                }

            }
        },
        onError: function (error) {

            var title   = error.hasOwnProperty('title') ? error.title :  Translator.trans("designer_common.messages.deleting_error");
            var message = error.message;

            window.bootstrap.modal.show(title, message, Translator.trans("designer_common.action.accept"), true);
        },
        always: function() {

        }
    }

};

// This is one type of inheritance
DeleteContentActivity.prototype = new Activity();

DeleteContentActivity.prototype.checkAllowProcess = function(){
    return true;
};

DeleteContentActivity.prototype.setCheckAllowProcess = function(f) {
    this.checkAllowProcess = f;

    return this;
}

/**
 * Set selector
 * @param selector
 * @returns {DeleteContent}
 */
DeleteContentActivity.prototype.setSelector = function(selector) {
    this.selector = selector;
    return this;
};

/**
 * Set url
 * @param url
 * @returns {DeleteContent}
 */
DeleteContentActivity.prototype.setUrl = function(url) {
    this.url = url;
    return this;
};

/**
 * Set title
 * @param title
 * @returns {DeleteContent}
 */
DeleteContentActivity.prototype.setTitle = function(title) {
    this.title = title;
    return this;
};

/**
 * Set Message
 * @param message
 * @returns {DeleteContent}
 */
DeleteContentActivity.prototype.setMessage = function(message) {
    this.message = message;
    return this;
};

/**
 *
 * @param redirectUrl
 * @returns {DeleteContent}
 */
DeleteContentActivity.prototype.setRedirectUrl = function(redirectUrl) {
    this.redirectUrl = redirectUrl;
    return this;
};

/**
 * @param params
 */
DeleteContentActivity.prototype.call = function(params) {
    var _this = this;

    Q.fcall(_this.functions.checkDeletion, params)
        .then(_this.functions.confirmDeletion)
        .then(_this.functions.deleteEntity)
        .then(_this.functions.onSuccess)
        .catch(_this.functions.onError)
        .done(_this.functions.always)
};

/**
 * Initializes DOM
 * @returns {DeleteContent}
 */
DeleteContentActivity.prototype.init = function() {

    var _this = this;

    $('body').on('click', this.selector, function (e) {
        e.preventDefault();

        if (!_this.checkAllowProcess()) {
            return false;
        }

        var el = $(this);

        var params = {
            element: el,
            module: el.data('module') ? el.data('module') : _this.module,
            url: el.data('url') ? el.data('url') : _this.url,
            title: el.data('title') ? el.data('title') : _this.title,
            message: el.data('message') ? el.data('message') : _this.message,
            redirectUrl: el.data('redirect-url') ? el.data('redirect-url') : _this.redirectUrl,
            managed: false
        };

        _this.call(params);
    });

    return this;
};

DeleteContentActivity.prototype.addParamToUrl = function(params, paramToAdd) {

    var pattern = new RegExp(/\?/g);
    var res = pattern.test(params.url);
    var signal = res ? '&' : '?';

    params.url += signal + paramToAdd;

    return this;
};
