<?php

namespace Comitium5\DesignerBundle\ValueObjects;

/**
 * Class GroupByObject
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\ValueObjects
 */
class GroupByObject
{
    /**
     * @var mixed
     */
    private $value;

    /**
     * @var int
     */
    private $quantity;

    /**
     * GroupByObject constructor.
     *
     * @param $value
     * @param int $quantity
     */
    public function __construct($value, int $quantity)
    {
        $this->value    = $value;
        $this->quantity = $quantity;
    }

    /**
     * @return mixed
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @return int
     */
    public function getQuantity(): int
    {
        return $this->quantity;
    }
}
