<?php

namespace Comitium5\DesignerBundle\ValueObjects;

/**
 * Class GroupByCollection
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\ValueObjects
 */
class GroupByCollection
{
    /**
     * @var GroupByObject[]
     */
    private $objects;

    /**
     * @var int
     */
    private $total;

    /**
     * GroupByCollection constructor.
     */
    public function __construct()
    {
        $this->objects = [];
        $this->total   = 0;
    }

    /**
     * @param GroupByObject $groupByObject
     *
     * @return $this
     */
    public function add(GroupByObject $groupByObject): GroupByCollection
    {
        $this->objects[] = $groupByObject;
        $this->total     += $groupByObject->getQuantity();

        return $this;
    }

    /**
     * @return GroupByObject[]
     */
    public function getObjects(): array
    {
        return $this->objects;
    }

    /**
     * @return int
     */
    public function getTotal(): int
    {
        return $this->total;
    }
}
