<?php

namespace Comitium5\DesignerBundle\ValueObjects\Asset;

/**
 * Class SearchAssetObject
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\ValueObjects\Asset
 */
class SearchAssetObject
{
    /**
     * @var string|null
     */
    private $searchText;

    /**
     * @var string|null
     */
    private $type;

    /**
     * @var int
     */
    private $page;

    /**
     * @var int
     */
    private $quantity;

    /**
     * SearchAssetObject constructor.
     *
     * @param string|null $searchText
     * @param string|null $type
     * @param int $page
     * @param int $quantity
     */
    public function __construct(string $searchText = null, string $type = null, int $page = 1, int $quantity = 12)
    {
        $this->searchText = $searchText;
        $this->type = $type;
        $this->page = $page;
        $this->quantity = $quantity;
    }

    /**
     * @return string|null
     */
    public function getSearchText(): ?string
    {
        return $this->searchText;
    }

    /**
     * @return string|null
     */
    public function getType(): ?string
    {
        return $this->type;
    }

    /**
     * @return int
     */
    public function getPage(): int
    {
        return $this->page;
    }

    /**
     * @return int
     */
    public function getQuantity(): int
    {
        return $this->quantity;
    }
}
