<?php

namespace Comitium5\DesignerBundle\UseCase\Page;

use Comitium5\DesignerBundle\Model\Interfaces\Page\DesignerPageInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Page\PageManagerInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Page\PageRepositoryInterface;

/**
 * Class DeletePageUseCase
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\UseCase\Page
 */
class DeletePageUseCase
{
    /**
     * @var PageRepositoryInterface
     */
    private $pageRepository;

    /**
     * DeletePageUseCase constructor.
     *
     * @param $pageRepository
     */
    public function __construct(PageRepositoryInterface $pageRepository)
    {
        $this->pageRepository = $pageRepository;
    }

    /**
     * @param int $originId
     *
     * @return bool
     */
    public function __invoke(int $originId): bool
    {
        $page = $this
            ->pageRepository
            ->getPageFromOrigin($originId);

        if ($page instanceof DesignerPageInterface) {
            $this
                ->pageRepository
                ->removePage($page);

            return true;
        }

        return false;
    }
}
