<?php

namespace Comitium5\DesignerBundle\UseCase\Asset;

use Comitium5\ApiClientBundle\Client\Services\AssetApiService;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;

/**
 * Class DeleteAssetUseCase
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\UseCase\Asset
 */
class DeleteAssetUseCase
{
    /**
     * @var AssetApiService
     */
    protected $apiService;

    /**
     * DeleteAssetUseCase constructor.
     *
     * @param AssetApiService $apiService
     */
    public function __construct(AssetApiService $apiService)
    {
        $this->apiService = $apiService;
    }

    /**
     * @param IdentifiedValue $identifiedValue
     *
     * @return bool
     */
    public function __invoke(IdentifiedValue $identifiedValue): bool
    {
        $response = $this
            ->apiService
            ->delete($identifiedValue);

        return isset($response["id"]) && $response["id"] === $identifiedValue->getId();
    }
}
