<?php

namespace Comitium5\DesignerBundle\Tests\UseCase\Asset;

use Comitium5\ApiClientBundle\Client\Services\AssetApiService;
use Comitium5\ApiClientBundle\ValueObject\ParametersValue;
use Comitium5\DesignerBundle\Model\Interfaces\Pagination\PaginationInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Pagination\PaginatorInterface;
use Comitium5\DesignerBundle\Tests\AbstractTestCase;
use Comitium5\DesignerBundle\UseCase\Asset\SearchAssetUseCase;
use Comitium5\DesignerBundle\ValueObjects\Asset\SearchAssetObject;

/**
 * Class SearchAssetUseCaseTest
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Tests\UseCase\Asset
 */
class SearchAssetUseCaseTest extends AbstractTestCase
{
    /**
     *
     */
    public function testSearch()
    {
        $useCase = new SearchAssetUseCase();

        $pagination = $useCase(
            $this->apiService(),
            $this->paginator(),
            new SearchAssetObject(
                "foo",
                "image",
                1
            )
        );

        $this->assertInstanceOf(PaginationInterface::class, $pagination);

        foreach ($pagination->getItems() as $item) {
            $this->assertContains("foo", $item["title"]);
        }
    }

    /**
     * @return \PHPUnit_Framework_MockObject_MockObject
     */
    private function apiService()
    {
        $mock = $this->createMock(AssetApiService::class);

        $mock
            ->method("findBy")
            ->willReturnCallback(function (ParametersValue $parametersValue) {
                $options = $parametersValue->getOptions();

                return [
                    "total"   => 6,
                    "pages"   => 3,
                    "page"    => $options["page"],
                    "limit"   => $options["limit"],
                    "results" => [
                        [
                            "id"   => 1,
                            "title" => "{$options['title']}-1",
                        ],
                        [
                            "id"   => 2,
                            "title" => "{$options['title']}-2",
                        ],
                    ],
                ];
            });

        return $mock;
    }

    /**
     * @return \PHPUnit_Framework_MockObject_MockObject
     */
    private function paginator()
    {
        $mock = $this->createMock(PaginatorInterface::class);

        $paginationMock = $this->createMock(PaginationInterface::class);

        $paginationMock
            ->method("setItems")
            ->willReturn($paginationMock);

        $paginationMock
            ->method("setTotalItemCount")
            ->willReturn($paginationMock);

        $mock
            ->method("paginate")
            ->willReturnCallback(function ($results) use ($paginationMock) {
                $paginationMock
                    ->method("getItems")
                    ->willReturn($results);

                return $paginationMock;
            });

        return $mock;
    }
}
