/**
 * sites.form.js
 */

$(document).ready(function(){
    var locale_modal = $('#locale-modal');
    locale_modal.find('[data-action="delete"]').on('click', function (e) {
        locale_modal.modal('hide');
        locale_modal.data('lc_container').remove();

    });
    var update_modal_info = function () {
        var locale = m_locale_select.find('option:selected').data('slug');
        locale_modal.find('#domain_info p').text(
            m_domain_input.val().urlparse() +
            locale_modal.data('ss_slug_input').val().urlparse().addStartSlash() +
            (typeof locale != 'undefined' ? locale : '')
        );
    };
    var update_table_info = function () {
        $(this).find('.locale-language').text($(this).find('input[id$=locale]').val());
        $(this).find('.locale-domain').text($(this).find('input[id$=domain]').val());
        $(this).find('.locale-default').text('1' == $(this).find('input[id$=default]').val() ? 'Sí' : 'No');
    };
    var set_modal = function () {
        var lc_container = $(this).is('.locale-row') ? $(this) : $(this).parents('.locale-row');
        var lc_locale_input = lc_container.find('input[id$=locale]');
        var lc_domain_input = lc_container.find('input[id$=domain]');
        var lc_default_input = lc_container.find('input[id$=default]');
        locale_modal.data('lc_container', lc_container);
        locale_modal.data('lc_locale_input', lc_locale_input);
        locale_modal.data('lc_domain_input', lc_domain_input);
        locale_modal.data('lc_default_input', lc_default_input);
        //
        m_domain_input.val(lc_domain_input.val());
        m_locale_select.select2('val', lc_locale_input.val());
        m_default_input.prop('checked', true == lc_default_input.val());

        if (true == lc_default_input.val()) {
            m_default_input.parents('.bootstrap-switch').removeClass('bootstrap-switch-off').addClass('bootstrap-switch-on');
        } else {
            m_default_input.parents('.bootstrap-switch').removeClass('bootstrap-switch-on').addClass('bootstrap-switch-off')
        }
        //
        locale_modal.data('ss_slug_input', lc_container.parents('.panel-subsite').data('ss_slug_input'));
        locale_modal.modal('show');
    };
    var save_modal = function (e) {
        e.preventDefault();
        var container = locale_modal.data('lc_container');
        locale_modal.data('lc_locale_input').val(m_locale_select.val());
        locale_modal.data('lc_domain_input').val(m_domain_input.val());
        locale_modal.data('lc_default_input').val(m_default_input.is(':checked') ? 1 : 0);
        locale_modal.modal('hide');
        update_table_info.bind(container)();
    };
    locale_modal.on('show.bs.modal', update_modal_info);
    $(document).on('click', '.btn-edit-locale', set_modal);
    var switch_event = function () {
        var checkbox_this = $(this).find('input');
        var label_sel = '.label-is-default';
        var container_sel = '.bootstrap-switch';
        var label_this = $(this).parents('.panel-subsite').find(label_sel);

        if (checkbox_this.prop('checked')) {
            label_this.show();
            $('.make-switch')
                .not(checkbox_this)
                .prop('checked', false);
            $(label_sel)
                .not(label_this)
                .hide();
            $(container_sel)
                .not($(this))
                .removeClass('bootstrap-switch-on')
                .addClass('bootstrap-switch-off');
        } else {
            label_this.hide();
        }
    };
    locale_modal.find('.save').on('click', save_modal);
    var m_domain_input = locale_modal.find('#domain_input input').on('keyup', update_modal_info);
    var m_locale_select = locale_modal.find('#locale_select select').on('change', update_modal_info);
    var m_default_input = locale_modal.find('.bootstrap-switch input');
    $('.cs_site_info').popover();
    var locale_selector = $("#locale_select select");
    var set_subsite = function () {
        var subsite = $(this);
        var locales_cl = $(this).find('.locale_container');
        var switches = $(this).find('.make-switch').bootstrapSwitch();
        $(this).data('ss_slug_input', $(this).find('input[id*=acronym]'));
        var title = $(this).find('.subsite-title');
        var locales = $(this).find('.site-locales');

        subsite
            .find('.bootstrap-switch')
            .on('click', switch_event);

        $('[data-action="delete"]', subsite).on('click', function (e) {
            var element = $(this);

            element
                .parents('.panel-collapse')
                .collapse('hide')
                .on('hidden.bs.collapse', function () {
                    element.parents('.panel-subsite').remove();
                });
        });

        locales_cl.collection({
            debug: true,
            label: false,
            prototype_name: '__subname__',
            button_template: locales_cl.data('button-prototype'),
            insertButtonSelector: '#' + subsite.find('.add-portfolio').attr('id'),
            afterCreate: function (e) {
                var el = e.detail.element;
                set_modal.bind(el)();
            }
        });
    };
    var subsites = $('.panel-subsite').each(function (i, e) {
        set_subsite.bind(e)();
    });
    var subsites_collection_form = $('#subsites_container');
    subsites_collection_form.collection({
        debug: true,
        label: false,
        button_template: subsites_collection_form.data('button-prototype'),
        insertButtonSelector: '.add-subsite',
        afterCreate: function (e) {
            var el = e.detail.element;
            el.find('.panel-collapse').collapse('show');
            set_subsite.bind(el)();
        }
    });
    function format(state) {
        if (!state.id) return state.text; // optgroup
        return "<img class='flag' src='" + locale_selector.data('image-path') + state.id.toLowerCase() + ".png'/>&nbsp;&nbsp;" + state.text;
    }
    locale_selector.select2({
        allowClear: true,
        formatResult: format,
        formatSelection: format,
        escapeMarkup: function (m) {
            return m;
        }
    });

    try {
        var url = Routing.generate('cs_sites_domain_suggest')
        m_domain_input.autocomplete({
            serviceUrl: url,
            minChars: 3,
            maxHeight: 400,
            width: 'auto',
            zIndex: 99999,
            noCache: false,
            onSelect: function(value, data){ m_domain_input.trigger('keyup');}
        });
    } catch (err) {}
});
