var DirectoriesManager = (function() {
    'use strict';
    var DirectoriesManager = function() {
        var _self = this;
        _self.initCheckboxes();

        Pagination.onChange.add(function() {
            _self.initSwitch(_self.container);
        });
    };

    DirectoriesManager.prototype.initCheckboxes = function() {
        $(document).on('click','[data-action="switch-directory"]', function() {

            var node  = $(this).find('[type="checkbox"]');
            var id    = node.data('id');
            var state = Number(node.is(':checked'));

            $.ajax({
                url: Routing.generate(
                    'cs_cms_directories_switch_enabled', {
                        id: id,
                        state: state
                    }, true)
                ,
                method: 'POST',
                success: function(response) {
                    if (response.updated) {
                        showToastrNotification('success',Translator.trans( state ? 'cms_directory.directory.page.message.enabled_success' : 'cms_directory.directory.page.message.disabled_success'));
                    }
                },
                error: function() {
                    showToastrNotification('error',Translator.trans('cms_directory.directory.page.message.enabled_disabled_error'));
                }
            });
        });
    };

    DirectoriesManager.prototype.initSwitch = function(element) {
        $(element).find('[type="checkbox"]').each(function () {
            $(this).bootstrapSwitch();
        });
    };

    return DirectoriesManager;
})();