/**
 * Class for signals logic implementation
 */
var SignalsAbstract = (function() {
    'use strict';

    /**
     * @constructor
     */
    function SignalsAbstract() {
        this.events = {};
    }

    /**
     *
     * @param {string} name
     * @param {function} handler
     * @param {boolean} addOnce
     * @returns {boolean}
     */
    SignalsAbstract.prototype.addHandler = function(name, handler, addOnce) {
        addOnce = typeof addOnce === 'undefined' ? false : addOnce;
        if(!handler instanceof Function) {
            return false;
        }

        if(addOnce) {
            this.events[name].addOnce(handler);
        } else {
            this.events[name].add(handler);
        }
    };

    /**
     * @param {string} name
     * @param {function} handler
     */
    SignalsAbstract.prototype.removeHandler = function(name, handler) {
        this.events[name].remove(handler);
    };

    /**
     * @param {string} name
     */
    SignalsAbstract.prototype.removeAllHandlers = function(name) {
        this.events[name].removeAll();
    };

    /**
     * @param {string} name
     * @param {object} parameters
     */
    SignalsAbstract.prototype.dispatch  = function(name, parameters) {
        parameters = typeof parameters === 'undefined' ? {} : parameters;
        this.events[name].dispatch(parameters);
    };

    return SignalsAbstract;
}());
