var Widget = Class.extend({
    init: function(id, layout, data)
    {
        this.id = id;
        this.locale = null;
        this.locales = [];
        this.layout = layout;
        this.uuid = null;
        this.uniqueId = null;
        this.name = '';
        this.item = null;
        this.items = [];
        this.code = '';
        this.object = null;
        this.startDate = null;
        this.endDate = null;
        this.toolbar = null;
        this.scriptNodes = [];
        this.fields = [];
        this.css = [];
        this.iframeId = ComitiumUtils.generateGUID();

        if(data) {
            this.id = data.widget;
            this.uuid = (data.id === null ? this.generateUuid() : data.id);
            this.uniqueId = this.generateUniqueId();


            var specificFields = data.parameters;
            this.object = {parameters: specificFields.parameters};
            this.fields = specificFields.fields;
            try {
                this.name = this.object.parameters._widget.name || '';
            } catch(e) {
                this.name = '';
            }

            this.startDate = data.startAt !== null ? moment(data.startAt.date).format('YYYY-MM-DD HH:mm') : null;
            this.endDate = data.endAt !== null ? moment(data.endAt.date).format('YYYY-MM-DD HH:mm') : null;
        }
        this.locale = this.layout.template.defaultLocale;
        this.locales = this.layout.template.locales;

        var locales = [this.locale].concat(this.locales);

        for(var i = 0; i < locales.length; i++) {
            if(typeof this.fields[locales[i].locale] === 'undefined'){
                this.fields[locales[i].locale] = {};
                this.fields.length++;
            }
        }
    },
    render: function(forExport)
    {
        return jQuery('<'+Widget.TAG+' id="'+(forExport ? this.uuid : this.uniqueId)+'"></'+Widget.TAG+'>');
    },
    renderObject: function(selector)
    {
        this.createDOMNode(selector, false);
        this.sync();

        if(this.item.parent().length > 0) {
            this.layout.template.widgetsStorage.add(this);
        }

        if(this.layout.template.mode === Template.STRUCTURE_MODE) {
            this.disable();
        } else {
            this.enable();
        }
    },
    getSelector: function(edit, force)
    {
        var selector = null;

        if(edit && !force){
            selector = Widget.TAG+'[id="'+this.uniqueId+'"]';
        } else if(force) {
            selector = Widget.TAG+'[id="'+this.uuid+'"]';
        }

        return selector;
    },
    getHtml: function(selector, force)
    {
        var locales = this.generateLocales();

        var routeParams = { id: this.id, locales: locales},
            edit = false,
            formParams = {};

        if(this.object !== null) {
            formParams.parameters = this.object.parameters;
            edit = true;
            if(!force) {
                formParams.edit = 1;
            }
        }

        var  modal = null,
            _self = this;

        var iframe = _self.createIframe(routeParams, formParams, edit).on('load', function(event){
            if(edit && !$(iframe).data('submited')) {
                return false;
            }

            selector = _self.getSelector(edit, force) === null ? selector : _self.getSelector(edit, force);

            _self.item = jQuery(selector, jQuery(Widget.IFRAME_SELECTOR).contents());

            var mimeType = jQuery(this).contents().get(0).contentType || jQuery(this).contents().get(0).mimeType;

            if(mimeType === Widget.MIME_TYPE_HTML) {
                if(force){
                    jQuery('form', jQuery(this).contents()).submit();
                } else {
                    modal.show(_self._bindWidgetAssetsActions.bind(_self, modal));
                }

            } else if(mimeType === Widget.MIME_TYPE_JSON) {
                modal.hide();
                var object = jQuery.parseJSON(jQuery(modal.getTarget()).fadeOut().find('iframe').contents().text());
                modal.remove();
                if(typeof object.message === 'undefined') {

                    _self.object = object;
                    _self.renderObject(selector, object);

                    if(edit && !force) {
                        _self.enableActionButtons();
                    }
                } else {
                    jQuery(selector, jQuery(Widget.IFRAME_SELECTOR).contents()).remove();
                }

                if(typeof CSWidgetQueue !== 'undefined' && force) {
                    CSWidgetQueue.dispatch(WidgetQueue.PROCESS_QUEUE_IN_RUNTIME_EVENT);
                }

                if(_self.layout.template.mode === Template.STRUCTURE_MODE) {
                    _self.disable();
                } else {
                    _self.enable();
                }
            }
        });

        modal = this.openModalForParams(iframe, edit);

        if(edit) {
            var form = this._createFormForSendParams(iframe.data('url'), formParams);
            form.appendTo('body');
            form.attr('target', this.iframeId)
                .submit()
                .remove();

            iframe.data('submited', true);
        }

        jQuery('body', jQuery(Widget.IFRAME_SELECTOR).contents()).removeClass(ContentManager.BODY_SHOW_HOT_ZONES_CLASS);
    },
    generateLocales: function() {
        var locales = [this.locale.locale];
        for(var i = 0; i < this.locales.length; i++) {
            locales.push(this.locales[i].locale);
        }

        return locales;
    },
    createIframe: function(params, formParams,  edit) {
        var url = edit ? Routing.generate('visual_editor_widget_init', params, true) : Routing.generate('visual_editor_widget_init', params, true),
            iframe = jQuery('<iframe />')
                        .attr('name', this.iframeId)
                        .attr('id', this.iframeId);

        if(edit) {
            return iframe.data('url', url);
        } else {
            return iframe.attr('src', url);
        }

    },
    _createFormForSendParams: function(url, params) {
        var form = jQuery('<form>')
                        .attr('action', url)
                        .attr('method', 'POST');

        function addFields(params, prefix) {
            for(key in params) {
                var name = typeof prefix === 'undefined' ? key : prefix+'['+key+']';
                if(typeof params[key] === 'object' || Object.prototype.toString.call(params[key]) === '[object Array]') {
                    addFields(params[key], name);
                } else {
                    jQuery('<input />')
                        .attr('type', 'hidden')
                        .attr('name', name)
                        .val(params[key])
                        .appendTo(form);
                }
            }
        }

        addFields(params);

        return form;
    },
    createDOMNode: function(selector, edit) {
        var html = this.createDOMElementsFromJson(this.object, !edit);

        jQuery(html).data('object', this);
        this.disableDomEvents(jQuery(selector, jQuery(Widget.IFRAME_SELECTOR).contents())
            .replaceWith(html)
            .end());
    },
    disableDomEvents: function(element) {
        element.find('a')
                .on('click', function(event){event.preventDefault();})
                .end()
                .find('a, img')
                .each(function() {
                    jQuery(this).prop('draggable', false);
                })
                .end()
                .find('form')
                .on('submit', function(event) {event.preventDefault();});
    },
    createDOMElementsFromJson: function(json, appendResources)
    {
        this.uuid = (this.uuid === null) ? json.uuid : this.uuid;
        this.uniqueId =  (this.uniqueId === null) ? this.generateUniqueId() : this.uniqueId;

        var element = this.render();
        //var iframe = jQuery(Widget.IFRAME_SELECTOR);

        if(appendResources) {
            for (var css in json.css) {
                this.css.push(new Css({source: '/'+json.css[css]}).append());
            }
        } /*else {
            for(var scriptNode in this.scriptNodes) {
                jQuery(this.scriptNodes[scriptNode]).remove();
            }
        }

        var iframeWindow = (iframe.get(0).contentWindow || iframe.get(0).contentDocument);
        for (var script in json.js) {
            var js = iframeWindow.document.createElement('script');
            js.type = 'text/javascript';
            js.src = json.js[script];
            iframeWindow.document.body.appendChild(js);
            this.scriptNodes.push(js);
        } */

        element.html(json.html[this.locale.locale]);

        this.item = element;
        this._checkDates();

        jQuery('script', element).remove();
        this._checkCols();
        this.bindToolbar();
        this.replaceEditableFieldsContent();
        this.bindEditableFields();

        return element;
    },
    enable: function()
    {
        var _self = this;
        this.item.CSDraggable({
            helper: 'move',
            dragstart: function() {
                setTimeout(function() {
                    _self.item.closest('body').addClass(ContentManager.BODY_SHOW_HOT_ZONES_CLASS);
                }, 100);
            },
            dragend: function() {
                setTimeout(function() {
                    _self.item.closest('body').removeClass(ContentManager.BODY_SHOW_HOT_ZONES_CLASS);
                }, 100);
            }
        });
        this.bindToolbar();
        this.item.attr('data-name', this.name);
        this.item.css('overflow', 'hidden');
        if(this.item.height() === 0 || $.trim(this.item.html()) === '') {
            this.item.addClass(Widget.EMPTY_CLASS);
        }
        this.item.css('overflow', '');
    },
    disable: function()
    {
        this.item.CSDraggable('destroy');
        this.item.removeClass(Widget.EMPTY_CLASS);
        this.unbindToolbar();
    },
    openModalForParams: function(content, edit)
    {
        if(typeof edit === 'undefined') edit = false;

        var modal = new Modal();
        var widget = this;
        modal.render(Widget.MODAL_SPECIFIC_CLASS);
        modal.addContent(content);

        modal.addOption(Modal.ACCEPT_OPTION,null,null,'btn mainBtn btn-save', function() {
            var iframe = jQuery(modal.getTarget()).find('iframe#'+widget.iframeId).get(0),
                form = iframe.contentWindow.jQuery('form'),
                sinteticEvent = $.Event( 'submit' ),
                validator = form.validate(),
                validate = validator.settings.submitHandler(form, sinteticEvent);

            if(typeof validate === 'undefined' && form.valid()) {
                modal.hide();
            }
        });

        modal.addOption(Modal.CANCEL_OPTION, null, null, 'btn defaultBtn btn-cancel', function() {
            if(!edit) {
                widget.remove();
            }
            modal.remove();
        });

        jQuery(modal.getTarget()).appendTo('body');

        return modal;
    },
    bindToolbar: function()
    {
        if(this.item.prop('id') == this.uniqueId) {
        	this._bindToolbar(this.item);
        }
    },
    _bindToolbar: function(item) {
        var _self = this;

        jQuery(this.item).hover(function(event) {
            event.stopPropagation();
            _self.showToolbar();
            _self.layout.getTarget().trigger('mouseout');
        }, function(event) {
            event.stopPropagation();
            _self.hideToolbar();
        });
    },
    unbindToolbar: function()
    {
        jQuery(this.item).off('mouseenter mouseleave');
        if(this.toolbar !== null) {
            this.toolbar.getTarget().remove();
        }
    },
    showToolbar: function()
    {
        var _self = this;
        _self.toolbar = new Toolbar(_self.item);
        _self.toolbar.render(this);

        _self.toolbar.remove(true, function(){
            _self.remove();
            _self.enableActionButtons();
        });

        var editDatesCallback = ContentManager.prototype.editDatesCallback(this);
        _self.toolbar.editDates(true, editDatesCallback);

        _self.toolbar.edit(true, function() {
            _self.getHtml();
        });

        _self.toolbar.editableFieldsReset(true, function() {
            _self.reset();
        });

        if(_self.locales.length > 0) {
            _self.toolbar.changeLocale(true, function(event) {
                var locale = jQuery(this).data('locale');

                var localeObject = _self.locales.filter(function(element) {
                    return element.locale = locale;
                });

                if(localeObject.length > 0) {
                    _self.changeLocale(localeObject[0]);
                }
            });

            jQuery('.'+Toolbar.CHANGE_LOCALE_CLASS, _self.toolbar.getTarget()).html(_self._generateChangeLocaleToolbarHtml());
        }



    },
    _generateChangeLocaleToolbarHtml: function() {
        var element = jQuery('<span/>')
                            .data('locale', this.locale.locale)
                            .addClass('active')
                            .wrap('div')
                            .html(this.locale.locale)
                            .parent();

        for(var i = 0; i < this.locales.length; i++) {
            element.append(jQuery('<span/>')
                .data('locale', this.locales[i].locale)
                .html(this.locales[i].locale))
                ;
        }

        return element.children();
    },
    hideToolbar: function()
    {
        this.toolbar.reset(this);
    },
    getTarget: function()
    {
        return this.item;
    },
    getTargets: function() {
        return this.items;
    },
    bindEditableFields: function() {
        this._bindEditableFields(this.item);
    },
    _bindEditableFields: function(item)
    {
        var widget = this;
        var localeIndex = widget.locale.locale;
        var loadCKEditorOnVisible = function(element, widget) {
            widget.getTarget().on(Widget.LOAD_CKEDITOR_EVENT, function(){
                CKEDITOR.inline( element.get(0), widget.inlineCKEditorConfig);
                widget.getTarget().off(Widget.LOAD_CKEDITOR_EVENT);
            });
        };

        jQuery(Widget.FIELD_TAG, item).each(function(){
            var type = jQuery(this).attr('type');
            if(type === Widget.FIELD_TYPE_HTML) {
                var editable = jQuery(this)
                    .wrapInner('<div />')
                    .children('div:first')
                    .prop('contenteditable', true)
                    .attr('lang', localeIndex);

                if(
                    widget.layout.getTarget().closest('.'+ContentManager.FUTURE_ELEMENT_CLASS).length > 0
                    || widget.layout.getTarget().closest('.'+ContentManager.PAST_ELEMENT_CLASS).length > 0
                ) {
                    loadCKEditorOnVisible(editable, widget);
                } else {
                    CKEDITOR.inline( editable.get(0), widget.inlineCKEditorConfig);
                }

            } else if([Widget.FIELD_TYPE_AUDIO, Widget.FIELD_TYPE_VIDEO, Widget.FIELD_TYPE_IMAGE].indexOf(type) !== -1) {
                if(jQuery(this).children().first().is('img,video,audio,picture')) {
                    jQuery(this).off('click').on('click', function() {
                        var modal = null,
                            //params = _self.params,
                            entityId = jQuery(this).data('entity-id'),
                            type = jQuery(this).attr('type'),
                            url = Routing.generate('render_asset_form', {assetId: entityId, locales: [localeIndex], type : type }, true),
                            field = jQuery(this);

                        var iframe = jQuery('<iframe />').attr('id', widget.iframeId).attr('src', url).load(function(responseText, textStatus, jqXHR){

                            var mimeType = jQuery(this).contents().get(0).contentType || jQuery(this).contents().get(0).mimeType;

                            if(mimeType === Widget.MIME_TYPE_HTML) {
                                modal.show(widget._bindWidgetAssetsActions.bind(widget, modal));
                            } else if(mimeType === Widget.MIME_TYPE_JSON) {
                                var object = jQuery.parseJSON(jQuery(modal.getTarget()).fadeOut().find('iframe').contents().text());

                                if(typeof object.message !== 'undefined') {
                                    modal.remove();
                                    return false;
                                }

                                var entity = object.entity;
                                if(type === Widget.FIELD_TYPE_IMAGE) {
                                    widget.replaceImageAttributes(entity, field);
                                } else if(type === Widget.FIELD_TYPE_VIDEO || type === Widget.FIELD_TYPE_AUDIO) {
                                    widget.replaceVideoAndAudioAttr(entity, field);
                                }

                                widget.fields[localeIndex][field.attr('name')] = entity;
                                widget.sync();
                                modal.remove();
                                widget.item.removeClass(Widget.LOADING_CLASS);
                                widget.enableActionButtons();
                            }
                        });

                        modal = widget.openModalForParams(iframe, true);
                    });
                }
            }
        });
    },
    replaceEditableFieldsContent: function() {
        this._replaceEditableFieldsContent(this.item);
    },
    _checkCols: function() {
        if(this.item.children().length === 1) {
            var child = this.item.children();
            var cssClasses = child.attr('class');

            if(typeof cssClasses !== 'undefined') {
                cssClasses = cssClasses.match(/(col-\w+-(\w+-)?\d+)/g);
            } else {
                cssClasses = null;
            }

            if(cssClasses !== null) {
                var length = cssClasses.length;
                for(var i = 0; i < length; i++) {
                    child.removeClass(cssClasses[i]);
                    this.item.addClass(cssClasses[i]);
                }
            }
        }
    },
    _replaceEditableFieldsContent: function(item)
    {
        var _self = this;
        jQuery(Widget.FIELD_TAG, item).each(function(){
            var type = jQuery(this).attr('type');
            var name = jQuery(this).attr('name');
            var localeIndex = _self.locale.locale;

            if(typeof _self.fields[_self.locale.locale][name] !== 'undefined') {
                if(type === Widget.FIELD_TYPE_HTML) {
                    jQuery(this).empty().html(_self.fields[localeIndex][name]);
                } else if([Widget.FIELD_TYPE_AUDIO, Widget.FIELD_TYPE_VIDEO].indexOf(type) !== -1) {
                    _self.replaceVideoAndAudioAttr(_self.fields[localeIndex][name], jQuery(this));
                } else if(type === Widget.FIELD_TYPE_IMAGE) {

                    var image = jQuery('img:first', jQuery(this));
                    if(image.get(0).complete) {
                        _self.replaceImageAttributes(_self.fields[localeIndex][name], jQuery(this));
                    } else {
                        var field = jQuery(this);
                        image.on('load error', function() {
                            _self.replaceImageAttributes(_self.fields[localeIndex][name], field);
                            $(this).off('load error');
                        });
                    }
                }
            }
        });
    },

    replaceImageAttributes: function(entity, field)
    {
        var image = jQuery('img:first', jQuery(field));

        field
            .attr('data-entity-id', entity.id)
            .data('entity-id', entity.id);

        entity = this._getCropOfImage(image, entity);

        var title = entity.title ? entity.title : entity.lang.title ? entity.lang.title : "";

        var parent = image.parent();

        if (parent.is("picture")) {
            parent.children("source").each(function(key, el){
                $(el).attr("srcset", entity.url);
            });
        }

        image
            .attr('src', entity.url)
            .attr('title', title)
            .attr('alt', title);
    },
    replaceVideoAndAudioAttr: function(entity, field)
    {
        //@TODO afegir mime type
        var element = jQuery('video:first') || jQuery('audio:first');
        jQuery(element)
            .empty()
            .append('<source src="'+entity.url+'" type="">');

        field
            .data('entity-id', entity.id)
            .attr('data-entity-id', entity.id);
    },
    reset: function() {
        this.disable();
        this.fields[this.locale.locale] = {};
        this.createDOMNode('#'+this.uniqueId, true);
        this._checkCols();
        this.sync();
        this.enableActionButtons();
        this.enable();
    },
    export: function() {
        var fields = {};
        for(var field in this.fields) {
            if(!jQuery.isEmptyObject(this.fields[field])) {
                fields[field] = this.fields[field];
            }
        }

        var layoutId = this.layout.id > 0 ?  this.layout.id :  this.layout.tmpId;

        return {
            widget: {
                id: this.id
            },
            id : this.uuid,
            layoutId: layoutId,
            startAt: this.startDate,
            endAt: this.endDate,
            parameters: {
                fields: fields,
                parameters: this.object.parameters
            },
            position: (this.getTarget().closest(Layout.TAG).find(Widget.TAG).index(this.getTarget()))+1
        };
    },
    json: function()
    {
        return JSON.stringify(
            this.export()
        );
    },
    getLayout: function() {
        return this.layout;
    },
    setLayout: function(layout) {
        this.layout = layout;
    },
    generateUniqueId: function() {
        return (this.uuid.toString())+(this.generateUuid());
    },
    generateUuid: function() {
      return Math.floor(Date.now());
    },
    bindObjectToDom: function() {

        var _self = this;
        _self.item = jQuery(Widget.TAG+'[id="'+this.uuid+'"]', jQuery(this.layout.template.getTarget())).data('object', this).first().addClass(Widget.LOADING_CLASS);
        _self.items = jQuery(Widget.TAG+'[id="'+this.uuid+'"]', jQuery(this.layout.template.getTarget())).not(this.item).toArray();
    },
    sync: function() {
    	if(this.items.length > 1) {
    		for(var item in this.items) {
	            this.replaceTargetsHtml(this.items[item]);
	            this._bindToolbar(this.items[item]);
	            this._replaceEditableFieldsContent(this.items[item]);
	            this._bindEditableFields(this.items[item]);
	            if(this.layout.template.mode === Template.STRUCTURE_MODE) {
	                this.disable();
	            }
	        }
    	}
    },
    replaceTargetsHtml: function(item) {
        jQuery(item)
            .html(this.item.html())
            .prop('id', this.item.prop('id'));
    },
    enableActionButtons: function() {
        this.getLayout().update(true);
    },
    remove: function() {
        jQuery(this.getTarget()).remove();
        jQuery(this.getTargets()).remove();
        this.layout.template.widgetsStorage.remove(this.uniqueId);
    },
    _checkDates: function() {
        var target = this.getTarget();
        var startDate = new Date(this.startDate);
        var endDate = new Date(this.endDate);

        target.removeClass(
        	ContentManager.FUTURE_ELEMENT_CLASS+
        	' '+ContentManager.PAST_ELEMENT_CLASS
        );
        if(this.startDate && startDate > new Date()) {
            target.addClass(ContentManager.FUTURE_ELEMENT_CLASS);
        } else if(this.endDate && endDate < new Date()){
            target.addClass(ContentManager.PAST_ELEMENT_CLASS);
        }
    },
    changeLocale: function(locale) {
        if(typeof locale !== 'undefined' && locale.id !== this.locale.id) {
            this.disable();
            this.locales = this.locales.concat(this.locale);
            this.locale = locale;
            this.locales = this.locales.filter(function(element) {
                return element.id !== locale.id;
            });

            this.createDOMNode('#'+this.uniqueId, true);
            this.sync();
            this.enableActionButtons();
            this.enable();
            this.getTarget().trigger(Widget.LOAD_CKEDITOR_EVENT);
        }
    },
    _getCropOfImage: function(image, entity) {
        var dimensions = this._getImageRealDimensions(image),
            redimension = null;
        if(
            typeof entity.children !== 'undefined' &&
            entity.children !== null &&
            entity.children.length > 0
        ) {
            redimension = this._getBestDimensionImage(dimensions, entity.children);
        }

        return redimension === null ? entity : redimension;
    },
    _getImageRealDimensions: function(image) {

        image = image.get(0);
        var width = image.naturalWidth || image.width;
        var height = image.naturalHeight || image.height;
        return {
            'width' : width,
            'height' : height,
            'ratio' : width / height
        }
    },
    _getBestDimensionImage: function(originalDimensions, candidates) {
        var bestCandidate = null,
            bestCandidateMetadata = null,
            i = 0,
            size = candidates.length,
            found = false,
            current = null,
            metadata = null,
            bestCandidateDistance = 0,
            currentDistance = 0;

        while(!found && i < size) {
            current = candidates[i];
            metadata = current.metadata;
            if(metadata.width === originalDimensions.width && metadata.height === originalDimensions.height) {
                found = true;
                bestCandidate = current;
            } else if(originalDimensions.ratio === (metadata.width / metadata.height)) {
                if(bestCandidate === null) {
                    bestCandidate = current;
                    bestCandidateMetadata = bestCandidate.metadata;
                } else {
                    bestCandidateDistance = Math.sqrt( Math.pow((originalDimensions.width-bestCandidateMetadata.width), 2) + Math.pow((originalDimensions.height-bestCandidateMetadata.height), 2) );
                    currentDistance = Math.sqrt( Math.pow((originalDimensions.width-metadata.width), 2) + Math.pow((originalDimensions.height-metadata.height), 2) );

                    if(currentDistance <= bestCandidateDistance && metadata.width >= originalDimensions.width && metadata.height >= originalDimensions.height) {
                        bestCandidate = current;
                        bestCandidateMetadata = bestCandidate.metadata;
                    }
                }
            }

            i++;
        }

        return bestCandidate;
    },
    _bindWidgetAssetsActions: function(modal) {
        var widget = this;

        function bind() {
            var iframe = jQuery('iframe#'+widget.iframeId).get(0),
                iframeJquery = iframe.contentWindow.jQuery,
                iframeWindow = iframe.contentWindow;

            if(typeof iframeJquery === 'undefined') {
                setTimeout(function() {
                    bind();
                }, 500);
            } else {
                iframeJquery(iframeWindow)
                    .on('cs:assetsEditOpen', function(){
                        jQuery('.'+Modal.MODAL_CLASS+'-options', modal.getTarget()).hide();
                    })
                    .on('cs:assetsEditClose', function(){
                        jQuery('.'+Modal.MODAL_CLASS+'-options', modal.getTarget()).show();
                    });
            }
        }

        bind();
    },
    clone: function(layout) {
        layout = typeof layout !== 'undefined' ? layout : this.layout;

        var clone = new Widget(this.id, layout);
        jQuery.extend(true, clone, this);

        clone.uuid = Math.random().toString(36).replace(/[^a-z 0-9]+/g, '').substr(1, 13);
        clone.object.uuid = clone.uuid;
        clone.object.parameters._uuid = clone.uuid;
        clone.uniqueId = this.generateUniqueId();
        clone.layout = layout;

        return clone;
    }
});

Widget.prototype.inlineCKEditorConfig = {
    "toolbar":"visualEditor",
    "style":"style_1",
    "template":"template_1",
    extraPlugins: "basicstyles,simpleuploads,preview,newpage,autogrow,justify,find,iframe,iframedialog,cslinks,csimage,csvideo,csaudio,cscustomhtml,jqueryspellchecker,sourcedialog",
    "skin":"kama",
    "autoGrow_minHeight":250,
    "simpleuploads_acceptedExtensions":"jpg|png",
    "simpleuploads_imageExtensions":"jpe?g|gif|png"
};

Widget.TAG = 'cswidget';
Widget.FIELD_TAG = 'csfield';
Widget.IFRAMEFORMID = 'cs-widget-init-iframe';
Widget.MIME_TYPE_JSON = 'application/json';
Widget.MIME_TYPE_HTML = 'text/html';
Widget.IFRAME_SELECTOR = '.csd-middle .site-wrapper iframe';
Widget.FIELD_TYPE_HTML = 'html';
Widget.FIELD_TYPE_IMAGE = 'image';
Widget.FIELD_TYPE_VIDEO = 'video';
Widget.FIELD_TYPE_AUDIO = 'sound';
Widget.MODAL_SPECIFIC_CLASS = 'csmodal-widgets';
Widget.MODAL_SMALL_SPECIFIC_CLASS = 'csmodal-small';
Widget.START_DATE_ID = 'widget-start-date';
Widget.END_DATE_ID = 'widget-end-date';
Widget.LOADING_CLASS = 'cswidget-loading';
Widget.PARAMS_IFRAME_NAME = 'cs-iframe-params';
Widget.LOAD_CKEDITOR_EVENT = 'loadCKEditor';
Widget.EMPTY_CLASS = 'csw-empty';
