var Toolbar = Class.extend({
	init: function(target)
	{
		this.disabled = false;
		this.elements = [];
		this.target = jQuery('.'+Toolbar.CLASS, target);
		if (this.target.length == 0) {
			this.target = jQuery('<div/>', {
				'class': Toolbar.CLASS
			});
			target.after(this.target);
		}
		this.target.data('object', this);
	},
	getTarget: function()
	{
		return this.target;
	},
	getElement: function()
	{
		return (
			this.elements.length > 0 ?
			this.elements[this.elements.length-1] :
			null
		);
	},
	render: function(item)
	{
		var /*offset, */node;

		if (!this.disabled) {
			node = jQuery('<ul/>');
			node.append(jQuery('<li/>', {
				html: Translator.trans(
					'cs_admin.designer.toolbar.visibility'
				),
				title: Translator.trans(
					'cs_admin.designer.toolbar.visibility'
				),
				class: Toolbar.VISIBILITY_CLASS
			}).hide());
			node.append(jQuery('<li/>', {
				html: Translator.trans(
					'cs_admin.designer.toolbar.lock'
				),
				title: Translator.trans(
					'cs_admin.designer.toolbar.lock'
				),
				class: Toolbar.LOCK_CLASS
			}).hide());
			node.append(jQuery('<li/>', {
				html: Translator.trans(
					'cs_admin.designer.toolbar.link'
				),
				title: Translator.trans(
					'cs_admin.designer.toolbar.link'
				),
				class: Toolbar.LINK_CLASS
			}).hide());
			node.append(jQuery('<li/>', {
				html: Translator.trans(
					'cs_admin.designer.toolbar.styles'
				),
				title: Translator.trans(
					'cs_admin.designer.toolbar.styles'
				),
				class: Toolbar.CSS_CLASS
			}).hide());
			node.append(jQuery('<li/>', {
				html: Translator.trans(
					'cs_admin.designer.toolbar.removeHeight'
				),
				title: Translator.trans(
					'cs_admin.designer.toolbar.removeHeight'
				),
				class: Toolbar.CLEAN_HEIGHT_CLASS
			}).hide());
            node.append(jQuery('<li/>', {
                html: Translator.trans(
    					'cs_admin.designer.toolbar.edit'
				),
                title: Translator.trans(
					'cs_admin.designer.toolbar.edit'
				),
                class: Toolbar.EDIT_CLASS
            }).hide());
            node.append(jQuery('<li/>', {
                html: Translator.trans(
					'cs_admin.designer.toolbar.editDate'
				),
                title: Translator.trans(
					'cs_admin.designer.toolbar.editDate'
				),
                class: Toolbar.DATE_CLASS
            }).hide());
            node.append(jQuery('<li/>', {
                html: Translator.trans(
                    'cs_admin.designer.toolbar.resetEditableFields'
                ),
                title: Translator.trans(
                    'cs_admin.designer.toolbar.resetEditableFields'
                ),
                class: Toolbar.RESET_EDITABLE_FIELDS_CLASS
            }).hide());
			node.append(jQuery('<li/>', {
				html: Translator.trans(
					'cs_admin.designer.toolbar.save'
				),
				title: Translator.trans(
					'cs_admin.designer.toolbar.save'
				),
				class: Toolbar.SAVE_CLASS
			}).hide());
            node.append(jQuery('<li/>', {
                html: Translator.trans(
                    'cs_admin.designer.toolbar.changeLocale'
                ),
                title: Translator.trans(
                    'cs_admin.designer.toolbar.changeLocale'
                ),
                class: Toolbar.CHANGE_LOCALE_CLASS
            }).hide());
			node.append(jQuery('<li/>', {
				html: Translator.trans(
					'cs_admin.designer.toolbar.remove'
				),
				title: Translator.trans(
					'cs_admin.designer.toolbar.remove'
				),
				class: Toolbar.REMOVE_CLASS
			}).hide());
            node.append(jQuery('<li/>', {
                html: Translator.trans(
                    'cs_admin.designer.toolbar.copy'
                ),
                title: Translator.trans(
                    'cs_admin.designer.toolbar.copy'
                ),
                class: Toolbar.COPY_CONTENT_CLASS
            }).hide());
            node.append(jQuery('<li/>', {
                html: Translator.trans(
                    'cs_admin.designer.toolbar.cut'
                ),
                title: Translator.trans(
                    'cs_admin.designer.toolbar.cut'
                ),
                class: Toolbar.CUT_CONTENT_CLASS
            }).hide());
            node.append(jQuery('<li/>', {
                html: Translator.trans(
                    'cs_admin.designer.toolbar.paste'
                ),
                title: Translator.trans(
                    'cs_admin.designer.toolbar.paste'
                ),
                class: Toolbar.PASTE_CONTENT_CLASS
            }).hide());

			this.getTarget().html(node);
			this.getTarget().append(jQuery('<span/>').addClass(Toolbar.REMOVE_BUTTONS_CLASS).append(jQuery('<a/>', {
				class: Toolbar.CONFIRM_CLASS
			})).append(jQuery('<a/>', {
				class: Toolbar.CANCEL_CLASS
			})).hide());
			/*offset = this.getTarget().offset();
			this.getTarget().css('left', offset.left+'px');
			this.getTarget().css('top', offset.top+'px');*/

			item.getTarget().append(this.getTarget());
			if (this.getElement() != item) {
				this.elements.push(item);
			}
			this.getTarget().show();
		}
	},
	reset: function(item)
	{
		var index;

		if (!this.disabled) {
			if (item) {
				index = this.elements.indexOf(item);
				if (index >= 0) {
					this.elements.splice(index, 1);
				}
				this.getTarget().hide().empty();
				if (this.getElement()) {
					this.getElement().showToolbar();
				}
			} else {
				try {
					delete this.elements;
				} catch(e) {
					this.elements = null;
				}
				this.getTarget().remove();
			}
		}
	},
	visibility: function(enable, active, action)
	{
		if (enable) {
			jQuery('.'+Toolbar.VISIBILITY_CLASS, this.getTarget())
				.removeClass(Toolbar.DISABLED_CLASS);
			if (active) {
				jQuery('.'+Toolbar.VISIBILITY_CLASS, this.getTarget())
					.addClass(Toolbar.ACTIVE_CLASS);
			}
		} else {
			jQuery('.'+Toolbar.VISIBILITY_CLASS, this.getTarget())
				.addClass(Toolbar.DISABLED_CLASS);
		}
		if (action) {
			jQuery('.'+Toolbar.VISIBILITY_CLASS, this.getTarget()).click(function(event){
				event.preventDefault();
                event.stopPropagation();
				if (!jQuery(this).hasClass(Toolbar.DISABLED_CLASS)) {
					jQuery(this).toggleClass(Toolbar.ACTIVE_CLASS);
					action(event);
				}
			});
			jQuery('.'+Toolbar.VISIBILITY_CLASS, this.getTarget()).show();
		}
	},
	lock: function(enable, active, action)
	{
		if (enable) {
			jQuery('.'+Toolbar.LOCK_CLASS, this.getTarget())
				.removeClass(Toolbar.DISABLED_CLASS);
			if (active) {
				jQuery('.'+Toolbar.LOCK_CLASS, this.getTarget())
					.addClass(Toolbar.ACTIVE_CLASS);
			}
		} else {
			jQuery('.'+Toolbar.LOCK_CLASS, this.getTarget())
				.addClass(Toolbar.DISABLED_CLASS);
		}
		if (action) {
			jQuery('.'+Toolbar.LOCK_CLASS, this.getTarget()).click(function(event){
				event.preventDefault();
                event.stopPropagation();
				if (!jQuery(this).hasClass(Toolbar.DISABLED_CLASS)) {
					jQuery(this).toggleClass(Toolbar.ACTIVE_CLASS);
					action(event);
				}
			});
			jQuery('.'+Toolbar.LOCK_CLASS, this.getTarget()).show();
		}
	},
	link: function(enable, active, action)
	{
		if (enable) {
			jQuery('.'+Toolbar.LINK_CLASS, this.getTarget())
				.removeClass(Toolbar.DISABLED_CLASS);
			if (active) {
				jQuery('.'+Toolbar.LINK_CLASS, this.getTarget())
					.addClass(Toolbar.ACTIVE_CLASS);
			}
		} else {
			jQuery('.'+Toolbar.LINK_CLASS, this.getTarget())
				.addClass(Toolbar.DISABLED_CLASS);
		}
		if (action) {
			jQuery('.'+Toolbar.LINK_CLASS, this.getTarget()).click(function(event){
				event.preventDefault();
                event.stopPropagation();
				if (!jQuery(this).hasClass(Toolbar.DISABLED_CLASS)) {
					jQuery(this).toggleClass(Toolbar.ACTIVE_CLASS);
					action(event);
				}
			});
			jQuery('.'+Toolbar.LINK_CLASS, this.getTarget()).show();
		}
	},
	css: function(enable, action)
	{
		if (enable) {
			jQuery('.'+Toolbar.CSS_CLASS, this.getTarget())
				.removeClass(Toolbar.DISABLED_CLASS);
		} else {
			jQuery('.'+Toolbar.CSS_CLASS, this.getTarget())
				.addClass(Toolbar.DISABLED_CLASS);
		}
		if (action) {
			jQuery('.'+Toolbar.CSS_CLASS, this.getTarget()).click(function(event){
				event.preventDefault();
                event.stopPropagation();
				if (!jQuery(this).hasClass(Toolbar.DISABLED_CLASS)) {
					action(event);
				}
			});
			jQuery('.'+Toolbar.CSS_CLASS, this.getTarget()).show();
		}
	},
	cleanHeight: function(enable, action)
	{
		if (enable) {
			jQuery('.'+Toolbar.CLEAN_HEIGHT_CLASS, this.getTarget())
				.removeClass(Toolbar.DISABLED_CLASS);
		} else {
			jQuery('.'+Toolbar.CLEAN_HEIGHT_CLASS, this.getTarget())
				.addClass(Toolbar.DISABLED_CLASS);
		}
		if (action) {
			jQuery('.'+Toolbar.CLEAN_HEIGHT_CLASS, this.getTarget()).click(function(event){
				event.preventDefault();
                event.stopPropagation();
				if (!jQuery(this).hasClass(Toolbar.DISABLED_CLASS)) {
					action(event);
				}
			});
			jQuery('.'+Toolbar.CLEAN_HEIGHT_CLASS, this.getTarget()).show();
		}
	},
	save: function(enable, active, action)
	{
		if (enable) {
			jQuery('.'+Toolbar.SAVE_CLASS, this.getTarget())
				.removeClass(Toolbar.DISABLED_CLASS);
			if (active) {
				jQuery('.'+Toolbar.SAVE_CLASS, this.getTarget())
					.addClass(Toolbar.ACTIVE_CLASS);
			}
		} else {
			jQuery('.'+Toolbar.SAVE_CLASS, this.getTarget())
				.addClass(Toolbar.DISABLED_CLASS);
		}
		if (action) {
			jQuery('.'+Toolbar.SAVE_CLASS, this.getTarget()).click(function(event){
				event.preventDefault();
                event.stopPropagation();
				if (!jQuery(this).hasClass(Toolbar.DISABLED_CLASS)) {
					jQuery(this).toggleClass(Toolbar.ACTIVE_CLASS);
					action(event);
				}
			});
			jQuery('.'+Toolbar.SAVE_CLASS, this.getTarget()).show();
		}
	},
	remove: function(enable, action, withoutConfirm)
	{
		var $this = this;

		if (enable) {
			jQuery('.'+Toolbar.REMOVE_CLASS, $this.getTarget())
				.removeClass(Toolbar.DISABLED_CLASS);
		} else {
			jQuery('.'+Toolbar.REMOVE_CLASS, $this.getTarget())
				.addClass(Toolbar.DISABLED_CLASS);
		}
		if (action) {
			jQuery('.'+Toolbar.REMOVE_CLASS, $this.getTarget()).click(function(event){
				event.preventDefault();
                event.stopPropagation();
				if (!jQuery(this).hasClass(Toolbar.DISABLED_CLASS)) {
					if (withoutConfirm) {
						action(event);
					} else {
						jQuery('span.'+Toolbar.REMOVE_BUTTONS_CLASS, $this.getTarget()).fadeToggle();
						
						jQuery('span.'+Toolbar.REMOVE_BUTTONS_CLASS+' a.'+Toolbar.CONFIRM_CLASS, $this.getTarget()).off('click');
						jQuery('span.'+Toolbar.REMOVE_BUTTONS_CLASS+' a.'+Toolbar.CONFIRM_CLASS, $this.getTarget()).click(function(event){
							event.preventDefault();
							action(event);
						});
						jQuery('span.'+Toolbar.REMOVE_BUTTONS_CLASS+' a.'+Toolbar.CANCEL_CLASS, $this.getTarget()).off('click');
						jQuery('span.'+Toolbar.REMOVE_BUTTONS_CLASS+' a.'+Toolbar.CANCEL_CLASS, $this.getTarget()).click(function(event){
							event.preventDefault();
							jQuery(this).parent().fadeOut();
						});
					}
				}
			});
			jQuery('.'+Toolbar.REMOVE_CLASS, $this.getTarget()).show();
		}
	},
	disable: function()
	{
		this.disabled = true;
		jQuery('li', this.getTarget()).each(function(){
			jQuery(this).data(
				'disabled', jQuery(this).hasClass(Toolbar.DISABLED_CLASS)
			);
			jQuery(this).addClass(Toolbar.DISABLED_CLASS);
		});
	},
	enable: function()
	{
		this.disabled = false;
		jQuery('li', this.getTarget()).each(function(){
			if (!jQuery(this).data('disabled')) {
				jQuery(this).removeClass(Toolbar.DISABLED_CLASS);
			}
			jQuery(this).data('disabled', null);
		});
	},
    editDates: function(enable, action)
    {
        var $this = this;

        if (enable) {
            jQuery('.'+Toolbar.DATE_CLASS, $this.getTarget())
                .removeClass(Toolbar.DISABLED_CLASS);
        } else {
            jQuery('.'+Toolbar.DATE_CLASS, $this.getTarget())
                .addClass(Toolbar.DISABLED_CLASS);
        }

        if(action) {
            jQuery('.'+Toolbar.DATE_CLASS, this.getTarget()).click(function(event){
                event.preventDefault();
                event.stopPropagation();
                if (!jQuery(this).hasClass(Toolbar.DISABLED_CLASS)) {
                    jQuery(this).toggleClass(Toolbar.ACTIVE_CLASS);
                    action(event);
                }
            });

            jQuery('.'+Toolbar.DATE_CLASS, $this.getTarget()).show();
        }
    },
    edit: function(enable, action)
    {
        var $this = this;

        if (enable) {
            jQuery('.'+Toolbar.EDIT_CLASS, $this.getTarget())
                .removeClass(Toolbar.DISABLED_CLASS);
        } else {
            jQuery('.'+Toolbar.EDIT_CLASS, $this.getTarget())
                .addClass(Toolbar.DISABLED_CLASS);
        }

        if(action) {
            jQuery('.'+Toolbar.EDIT_CLASS, this.getTarget()).click(function(event){
                event.preventDefault();
                event.stopPropagation();
                if (!jQuery(this).hasClass(Toolbar.DISABLED_CLASS)) {
                    jQuery(this).toggleClass(Toolbar.ACTIVE_CLASS);
                    action(event);
                }
            });

            jQuery('.'+Toolbar.EDIT_CLASS, $this.getTarget()).show();
        }
    },
    editableFieldsReset: function(enable, action)
    {
        var $this = this;

        if (enable) {
            jQuery('.'+Toolbar.RESET_EDITABLE_FIELDS_CLASS, $this.getTarget())
                .removeClass(Toolbar.DISABLED_CLASS);
        } else {
            jQuery('.'+Toolbar.RESET_EDITABLE_FIELDS_CLASS, $this.getTarget())
                .addClass(Toolbar.DISABLED_CLASS);
        }

        if(action) {
            jQuery('.'+Toolbar.RESET_EDITABLE_FIELDS_CLASS, this.getTarget()).click(function(event){
                event.preventDefault();
                event.stopPropagation();
                if (!jQuery(this).hasClass(Toolbar.DISABLED_CLASS)) {
                    jQuery(this).toggleClass(Toolbar.ACTIVE_CLASS);
                    action(event);
                }
            });

            jQuery('.'+Toolbar.RESET_EDITABLE_FIELDS_CLASS, $this.getTarget()).show();
        }
    },
    changeLocale: function(enable, action)
    {
        var $this = this;

        if (enable) {
            jQuery('.'+Toolbar.CHANGE_LOCALE_CLASS, $this.getTarget())
                .removeClass(Toolbar.DISABLED_CLASS);
        } else {
            jQuery('.'+Toolbar.CHANGE_LOCALE_CLASS, $this.getTarget())
                .addClass(Toolbar.DISABLED_CLASS);
        }

        if(action) {
            jQuery('.'+Toolbar.CHANGE_LOCALE_CLASS, this.getTarget()).click(function(event){
                event.preventDefault();
                event.stopPropagation();
                if (!jQuery(this).hasClass(Toolbar.DISABLED_CLASS)) {
                    jQuery(this).toggleClass(Toolbar.ACTIVE_CLASS);
                    
                    if(!jQuery(this).children('span:not(.active)').is(':visible')) {
                        jQuery(this)
                            .children('span:not(.active)')
                            .css('display', 'block')
                            .on('click', function(event) {
                                event.stopPropagation();
                                var parent = jQuery(this).parent();
                                jQuery(this)
                                    .siblings()
                                    .removeClass('active')
                                    .css('display', 'none')
                                    .off('click')
                                    .end()
                                    .addClass('active')
                                    .prependTo(parent);

                                action.call(this, event);
                            });
                    } else {
                        jQuery(this)
                            .children('span:not(.active)').css('display', 'none')
                            .off('click');
                    }


                }
            });

            jQuery('.'+Toolbar.CHANGE_LOCALE_CLASS, $this.getTarget()).show();
        }
    },
    copy: function(enable, action)
    {
        var $this = this;

        if (enable) {
            jQuery('.'+Toolbar.COPY_CONTENT_CLASS, $this.getTarget())
                .removeClass(Toolbar.DISABLED_CLASS);
        } else {
            jQuery('.'+Toolbar.COPY_CONTENT_CLASS, $this.getTarget())
                .addClass(Toolbar.DISABLED_CLASS);
        }

        if(action) {
            jQuery('.'+Toolbar.COPY_CONTENT_CLASS, this.getTarget()).click(function(event){
                event.preventDefault();
                event.stopPropagation();
                if (!jQuery(this).hasClass(Toolbar.DISABLED_CLASS)) {
                    jQuery(this).toggleClass(Toolbar.ACTIVE_CLASS);
                    action(event);
                }
            });

            jQuery('.'+Toolbar.COPY_CONTENT_CLASS, $this.getTarget()).show();
        }
    },
    cut: function(enable, action)
    {
        var $this = this;

        if (enable) {
            jQuery('.'+Toolbar.CUT_CONTENT_CLASS, $this.getTarget())
                .removeClass(Toolbar.DISABLED_CLASS);
        } else {
            jQuery('.'+Toolbar.CUT_CONTENT_CLASS, $this.getTarget())
                .addClass(Toolbar.DISABLED_CLASS);
        }

        if(action) {
            jQuery('.'+Toolbar.CUT_CONTENT_CLASS, this.getTarget()).click(function(event){
                event.preventDefault();
                event.stopPropagation();
                if (!jQuery(this).hasClass(Toolbar.DISABLED_CLASS)) {
                    jQuery(this).toggleClass(Toolbar.ACTIVE_CLASS);
                    action(event);
                }
            });

            jQuery('.'+Toolbar.CUT_CONTENT_CLASS, $this.getTarget()).show();
        }
    },
    paste: function(enable, action)
    {
        var $this = this;

        if (enable) {
            jQuery('.'+Toolbar.PASTE_CONTENT_CLASS, $this.getTarget())
                .removeClass(Toolbar.DISABLED_CLASS);
        } else {
            jQuery('.'+Toolbar.PASTE_CONTENT_CLASS, $this.getTarget())
                .addClass(Toolbar.DISABLED_CLASS);
        }

        if(action) {
            jQuery('.'+Toolbar.PASTE_CONTENT_CLASS, this.getTarget()).click(function(event){
                event.preventDefault();
                event.stopPropagation();
                if (!jQuery(this).hasClass(Toolbar.DISABLED_CLASS)) {
                    jQuery(this).toggleClass(Toolbar.ACTIVE_CLASS);
                    action(event);
                }
            });

            jQuery('.'+Toolbar.PASTE_CONTENT_CLASS, $this.getTarget()).show();
        }
    },
});
Toolbar.CLASS = 'cstoolbar';
Toolbar.DISABLED_CLASS = 'disabled';
Toolbar.ACTIVE_CLASS = 'active';
Toolbar.VISIBILITY_CLASS = 'visibility';
Toolbar.LOCK_CLASS = 'lock';
Toolbar.LINK_CLASS = 'link';
Toolbar.CSS_CLASS = 'css';
Toolbar.CLEAN_HEIGHT_CLASS = 'clean-height';
Toolbar.SAVE_CLASS = 'save';
Toolbar.REMOVE_CLASS = 'remove';
Toolbar.CONFIRM_CLASS = 'confirm';
Toolbar.CANCEL_CLASS = 'cancel';
Toolbar.DATE_CLASS = 'edit-date';
Toolbar.EDIT_CLASS = 'edit';
Toolbar.RESET_EDITABLE_FIELDS_CLASS = 'editable-fields-reset';
Toolbar.CHANGE_LOCALE_CLASS = 'locale';
Toolbar.REMOVE_BUTTONS_CLASS = 'remove-buttons';
Toolbar.COPY_CONTENT_CLASS = 'copy';
Toolbar.CUT_CONTENT_CLASS = 'cut';
Toolbar.PASTE_CONTENT_CLASS = 'paste';