var Css = Class.extend({
	id: 0,
	name: '',
	source: '',
    code: '',
    item: null,

	init: function(data)
	{
		if (typeof(data) != "undefined") {
			this.load(data);
		}
	},
	load: function(data)
	{
		try {
			if (typeof(data) == "string") {
				data = jQuery.parseJSON(data);
			}
			this.id = data.id;
			this.name = data.name;
			this.source = data.source;
            this.code = data.code;
		} catch(error) {
			
		}
	},
    append: function() {
        if(typeof this.source === 'string') {
            this.item = jQuery('<link rel="stylesheet" href="' + this.source + '" type="text/css" />');
        } else {
            this.item = jQuery('<style type="text/css">'+this.code+'</style>');
        }

        if(jQuery('#'+Css.TAG_ID, CSTemplate.getTarget().get(0).ownerDocument).length > 0) {
            this.item.insertAfter(jQuery('#'+Css.TAG_ID, CSTemplate.getTarget().get(0).ownerDocument));
        } else {
            this.item.appendTo(jQuery('head', CSTemplate.getTarget().get(0).ownerDocument));
        }

        return this;
    },
    remove: function() {

        if(this.item) {
            this.item.remove();
        }

        return this;
    }
});

Css.TAG_ID = 'csstyles';