function TemplateSelectionModal() {
    this.hasTemplateAssigned = $("[data-has-template]").data("has-template");
    this.modalContainer = $("#template-selection-modal");
    this.contentContainer = null;
    this.btnSelectTemplate = null;
    this.btnCancel = null;
    this.comitiumUrl = null;
    this.btnOpen = null;
    this.btnClose = null;

    this.init();
}

TemplateSelectionModal.prototype.init = function () {
    var _this = this;
    _this.bindModalElements();
    _this.bindModalEvents();

    if (_this.hasTemplateAssigned === 0) {
        _this.openModalAction();
    }
};

TemplateSelectionModal.prototype.bindSelectTemplate = function () {
    var _this = this;
    _this.btnSelectTemplate.attr("disabled", false);
    _this.btnSelectTemplate.on("click", function () {
        _this.selectTemplateAction();
    })
};

TemplateSelectionModal.prototype.bindModalElements = function () {
    var _this = this;
    _this.contentContainer = _this.modalContainer.find(".modal-body");
    _this.btnSelectTemplate = _this.modalContainer.find('[data-btn-type="save"]');
    _this.btnCancel = _this.modalContainer.find('[data-btn-type="cancel"]');
    _this.btnClose = _this.modalContainer.find("[data-close-select-template-modal-btn]");
    _this.btnOpen = $("[data-open-select-template-modal-btn]");
    _this.comitiumUrl = $("div[data-cancel-url]").data("cancel-url")
};

TemplateSelectionModal.prototype.bindModalEvents = function () {
    var _this = this;
    if (_this.modalContainer.length > 0) {
        _this.bindCloseModal();
        _this.bindOpenModal();
        _this.bindRadioButtons();
    }
};

TemplateSelectionModal.prototype.bindRadioButtons = function () {
    var _this = this;
    _this.modalContainer.find("input[name=templates]").on("click", function () {
        _this.bindSelectTemplate();
        if (_this.hasTemplateAssigned === 1) {
            _this.showMessage("cs_admin.designer.modal.change-template-alert");
        }
    });
};

TemplateSelectionModal.prototype.bindOpenModal = function () {
    var _this = this;
    _this.btnOpen.on("click", function () {
        _this.showModal();
        _this.createModalBackgroundElement()
    });
};

TemplateSelectionModal.prototype.bindCloseModal = function () {
    var _this = this;
    _this.btnClose.on("click", function () {
        _this.closeModalAction();
    });
};

TemplateSelectionModal.prototype.openModalAction = function () {
    var _this = this;
    _this.showModal();
    _this.createModalBackgroundElement()
};

TemplateSelectionModal.prototype.closeModalAction = function () {
    var _this = this;
    _this.closeModal();
    _this.destroyModalBackgroundElement()
    if (_this.hasTemplateAssigned === 0) {
        _this.returnToComitium();
    }
};


TemplateSelectionModal.prototype.selectTemplateAction = function () {
    var _this = this;
    var pageId = _this.fetchPageId();
    var templateId = _this.fetchTemplateId();

    if (pageId === undefined || templateId === undefined ) {
        _this.showMessage("cs_admin.designer.modal.missingTemplate");
    }

    _this.assignRequest(pageId, templateId);
};

TemplateSelectionModal.prototype.assignRequest = function (pageId, templateId) {
    var _this = this;

    return $.ajax({
        url: Routing.generate("designer_pages_assign_template", {
            pageId: pageId,
            templateId: templateId,
        }),
        type: "POST",
        success: function (data) {
            // _this.contentContainer.html(data.status);
            _this.reloadPage();
        }
    });
};

TemplateSelectionModal.prototype.showModal = function () {
    var _this = this;
    _this.modalContainer.show();
};

TemplateSelectionModal.prototype.closeModal = function () {
    var _this = this;
    _this.modalContainer.fadeOut();
};

TemplateSelectionModal.prototype.reloadPage = function () {
    var _this = this;
    location.reload();
};

TemplateSelectionModal.prototype.createModalBackgroundElement = function () {
    var _this = this;
    var element = $("<div/>", {
        id: "template-selection-modal-background",
        class: "modal-backdrop in"
    });

    _this.modalContainer.before(element);
};

TemplateSelectionModal.prototype.destroyModalBackgroundElement = function () {
    var _this = this;
    var element = $("div#template-selection-modal-background");
    element.remove();
};

TemplateSelectionModal.prototype.fetchPageId = function () {
    var _this = this;
    return _this.modalContainer.data("current-page-id");
};

TemplateSelectionModal.prototype.fetchTemplateId = function () {
    var _this = this;

    return _this.modalContainer.find("input:checked[name=templates]").val();
};

TemplateSelectionModal.prototype.returnToComitium = function () {
    var _this = this;
    window.location = _this.comitiumUrl;
};

TemplateSelectionModal.prototype.showMessage = function (message) {
    var _this = this;
    var messageElement = _this.modalContainer.find("p#template-selection-message");
    var text = Translator.trans(message);

    if (messageElement.length > 0) {
        messageElement.html(text);
        return;
    }

    var element = $("<p/>", {
        id: "template-selection-message",
        class: "modal-footer-alert"
    });

    element.html(text);

    _this.modalContainer.find(".modal-footer").prepend(element);

};

document.addEventListener('DOMContentLoaded', function () {
    var templateSelectionModal = new TemplateSelectionModal();
});
