var ClipboardCopyHelper = function (options) {
    this.defaultOptions = {
        tooltipOptions: {
            placement: "top",
            title: Translator.trans("common.options_rollover.copyURL_success")
        }
    };

    this.resolveOptions(options);
};

ClipboardCopyHelper.prototype.resolveOptions = function (options) {
    return Object.assign(this.defaultOptions, options);
};

ClipboardCopyHelper.prototype.bindTooltipAction = function (element, copyValue) {
    var defaultOptions = this.defaultOptions;

    var title = element.attr("title");

    this.copyToClipboard(copyValue);

    element
        .removeAttr("title")
        .tooltip(defaultOptions.tooltipOptions)
        .tooltip("show");

    setTimeout(function () {
        element
            .tooltip("destroy")
            .attr("title", title);
    }, 1000);
};

ClipboardCopyHelper.prototype.copyToClipboard = function (value) {
    var tmpElement = document.createElement("input");

    tmpElement.setAttribute("value", value);

    document.body.appendChild(tmpElement);

    tmpElement.select();

    document.execCommand("copy");

    document.body.removeChild(tmpElement);
};