var AceEditor = function(options){
    this.options = {
        position: "absolute",
        height: null
    };

    this.editorOptions = {
        enableBasicAutocompletion: true,
        highlightSelectedWord: true,
        enableMultiselect: true,
        showPrintMargin: false
    };

    this.options = Object.assign(this.options, options);
};

AceEditor.prototype.init = function(textarea, mode){

    textarea = typeof textarea == "string" ? $(textarea) : textarea;

    var editDiv = $('<div>', {
        position: this.options.position,
        height: this.options.height === null ? textarea.height() : this.options.height,
        'class': textarea.attr('class')
    }).insertBefore(textarea);

    textarea.css('display', 'none');

    var editor = ace.edit(editDiv[0]);

    editor.setOptions(this.editorOptions);
    editor.$blockScrolling = Infinity;

    editor.getSession().setValue(textarea.val());
    editor.getSession().setMode("ace/mode/" + mode);

    textarea.on('change', function(e){
        editor.getSession().setValue(textarea.html());
    });

    editDiv.on('focusout', function(){
        textarea.val(editor.getSession().getValue());
    });

    textarea.data("aceEditor", editor);
};
