CKEDITOR.plugins.add('csvideo', {
    init: function(editor) {
        editor.csVideo = CsAsset.init("video");

        editor
            .csVideo
            .setAbsoluteUrlFromCKEditor(editor);

        var command = new CKEDITOR.command( editor, {
            exec: function( editor ) {

                _initEvents();

                var selectedElement = editor.getSelection().getSelectedElement();
                var asset = _build(selectedElement);

                editor.csVideo.exec(asset, function(element){
                    _createElement(element);
                });
            }
        });

        var _initEvents = function() {

            editor.focusManager.lock();

            editor.csVideo.signals.onDestroyModal.add(function(){
                editor.focusManager.unlock();
                editor.csVideo.asset.id = "";
            });
        };

        var _createElement = function(element){
            var parent = getParent(editor.getSelection().getSelectedElement());

            if (parent) {
                parent.remove();
            }

            if (element.asset.src) {
                var e = editor.document.createElement( 'video');
                e.setAttribute('title', element.asset.title);
                e.setAttribute('controls', "");
                e.setAttribute('width', "100%");
                if (element.asset.poster) {
                    e.setAttribute('poster', element.asset.poster);
                }
                var source = editor.document.createElement( 'source');
                source.setAttribute('src', element.asset.src);
                source.appendTo(e);
            } else {
                var e = editor.document.createElement("div");
                e.appendHtml(element.asset.embed);
            }

            if (element.asset.html) {
                var html    = element.asset.html.replace("@asset@", e.getOuterHtml());
                var wrapper = editor.document.createElement(createElementFromHTML(html));

                editor.insertElement(wrapper);
            } else {
                editor.insertElement(e);
            }
        };

        var _build = function(element) {

            var asset  = editor.csVideo.createAsset();

            if (!element || !element.is("video") || !element.is("iframe")) {
                return asset;
            }

            var parent = getParent(element);

            if (parent) {
                asset.html = parent.getOuterHtml().replace(/<img[^>]*>/, "@asset@");
            }

            if (element.getAttribute('src')) {
                asset.src = element.getAttribute('src');
            }
            if (element.getAttribute('title')) {
                asset.title = element.getAttribute('title');
            }
            if (element.getAttribute('poster')) {
                asset.poster = element.getAttribute('poster');
            }

            return asset;
        };

        function createElementFromHTML(htmlString) {
            var div = document.createElement('div');

            div.innerHTML = htmlString.trim();

            return div.firstChild;
        }

        function getParent(element) {

            if (!element) {
                return null;
            }

            var parents = element.getParents(true);
            var parent = null;

            parents.forEach(function(p){
                if (p.hasAttribute("data-ck-asset-wrapper")) {
                    parent = p;
                    return false;
                }
            });

            return parent;
        }

        editor.addCommand( 'csvideo', command);

        editor.ui.addButton( 'CsVideo', {
            label: Translator.trans('cs_core.cs_video.label'),
            command: 'csvideo',
            toolbar: 'video',
            icon: this.path + 'icons/csvideo.png'
        });
    }
});
