<?php

namespace Comitium5\DesignerBundle\Resolver\Search\Suggest;

use Comitium5\ApiClientBundle\ApiClient\ResourcesTypes;

/**
 * Class ElasticSearchQueryFieldsResolver
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\DesignerBundle\Resolver\Search\Suggest
 */
final class ElasticSearchQueryFieldsResolver
{
    /**
     * @param string $contentType
     *
     * @return array
     */
    public function __invoke(string $contentType): array
    {
        $fields = [];

        switch($contentType) {
            case ResourcesTypes::CATEGORY:
                $fields = $this->findByTitle($fields);
                $fields = $this->findByName($fields);
                break;
            case ResourcesTypes::ARTICLE:
                $fields = $this->findByTitle($fields);
                $fields = $this->findByName($fields);
                $fields = $this->findByAuthor($fields);
                break;
            case ResourcesTypes::TAG:
            case ResourcesTypes::DIARY:
                $fields = $this->findByTitle($fields);
                $fields = $this->findByName($fields);
                $fields = $this->findByDescription($fields);
                break;
            case ResourcesTypes::AUTHOR:
                $fields = $this->findByTitle($fields);
                $fields = $this->findByFullName($fields);
                $fields = $this->findByEmail($fields);
                break;
            case ResourcesTypes::DIRECTORY:
            case ResourcesTypes::LIVE_EVENT:
                $fields = $this->findByTitle($fields);
                $fields = $this->findByDescription($fields);
                break;
            case ResourcesTypes::ACTIVITY:
                $fields = $this->findByTitle($fields);
                $fields = $this->findByDescription($fields);
                $fields = $this->findByDetails($fields);
                break;
            case ResourcesTypes::CLASSIFIED:
                $fields = $this->findByTitle($fields);
                $fields = $this->findByClassified($fields);
                break;
            case ResourcesTypes::POLL:
                $fields = $this->findByTitle($fields);
                $fields = $this->findByQuestion($fields);
                break;
            case ResourcesTypes::NEWSLETTER_TEMPLATE:
            case ResourcesTypes::PAGE:
            case ResourcesTypes::GALLERY:
            default:
                $fields = $this->findByTitle($fields);
                break;
        }

        return $fields;
    }

    /**
     * @param array $fields
     *
     * @return array
     */
    protected function findByTitle(array $fields): array
    {
        return array_merge($fields, [
            'title.suggest',
        ]);
    }

    /**
     * @param array $fields
     *
     * @return array
     */
    protected function findByName(array $fields): array
    {
        return array_merge($fields, [
            'name.suggest',
        ]);
    }

    /**
     * @param array $fields
     *
     * @return array
     */
    protected function findByFullName(array $fields): array
    {
        return array_merge($fields, [
            'fullName.suggest',
        ]);
    }

    /**
     * @param array $fields
     *
     * @return array
     */
    protected function findByEmail(array $fields): array
    {
        return array_merge($fields, [
            'email.suggest',
        ]);
    }

    /**
     * @param array $fields
     *
     * @return array
     */
    protected function findByAuthor(array $fields): array
    {
        return array_merge($fields, [
            'author.name.suggest',
            'author.surname.suggest',
        ]);
    }

    /**
     * @param array $fields
     *
     * @return array
     */
    protected function findByDescription(array $fields): array
    {
        return array_merge($fields, [
            'description.suggest',
        ]);
    }

    /**
     * @param array $fields
     *
     * @return array
     */
    protected function findByDetails(array $fields): array
    {
        return array_merge($fields, [
            'details.suggest',
        ]);
    }

    /**
     * @param array $fields
     *
     * @return array
     */
    protected function findByClassified(array $fields): array
    {
        return array_merge($fields, [
            'text.suggest',
            'referencePayment.suggest',
        ]);
    }

    /**
     * @param array $fields
     *
     * @return array
     */
    protected function findByQuestion(array $fields): array
    {
        return array_merge($fields, [
            'answers.answer.suggest',
        ]);
    }
}
