<?php

namespace Comitium5\DesignerBundle\Model\Traits\View;

use Comitium5\DesignerBundle\Model\Interfaces\View\ViewInterface;
use Doctrine\Common\Collections\Collection;

/**
 * Trait ViewCollectionTrait
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Traits\View
 */
trait ViewCollectionTrait
{
    /**
     * @var Collection
     */
    private $views;

    /**
     * @return Collection
     */
    public function getViews()
    {
        return $this->views;
    }

    /**
     * @param Collection $views
     *
     * @return $this
     */
    public function setViews(Collection $views)
    {
        $this->views = $views;

        return $this;
    }

    /**
     * @param ViewInterface $view
     *
     * @return $this
     */
    public function addView(ViewInterface $view)
    {
        if (!$this->views->contains($view)) {
            $this
                ->views
                ->add($view);
        }

        return $this;
    }

    /**
     * @param ViewInterface $view
     *
     * @return $this
     */
    public function removeView(ViewInterface $view)
    {
        if ($this->views->contains($view)) {
            $this
                ->views
                ->removeElement($view);
        }

        return $this;
    }
}
