<?php

namespace Comitium5\DesignerBundle\Model\Traits;

use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;

/**
 * Class UserTokenDependencyTrait
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package ComitiumSuite\Components\Core\Traits\User
 */
trait UserTokenDependencyTrait
{
    /**
     * @var TokenStorageInterface
     */
    protected $tokenStorage;

    /**
     * @return mixed
     */
    public function getTokenStorage()
    {
        return $this->tokenStorage;
    }

    /**
     * @param mixed $tokenStorage
     * @return $this
     */
    public function setTokenStorage(TokenStorageInterface $tokenStorage)
    {
        $this->tokenStorage = $tokenStorage;

        return $this;
    }

    /**
     * @return UserInterface|null
     */
    public function getStorageUser()
    {
        $token = $this
            ->tokenStorage
            ->getToken();

        if ($token == null) {
            return null;
        }

        $user = $token->getUser();

        if (!$user instanceof UserInterface) {
            return null;
        }

        return $user;
    }
}