<?php

namespace Comitium5\DesignerBundle\Model\Traits;

use DateTime;

/**
 * Class PublishDateTrait
 *
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 * @package Comitium5\DesignerBundle\Model\Traits
 */
trait PublishDateTrait
{
    /**
     * @var DateTime
     */
    protected $publishedAt;

    /**
     * @var DateTime
     */
    protected $unPublishedAt;

    /**
     * @return mixed
     */
    public function getPublishedAt()
    {
        return $this->publishedAt;
    }

    /**
     * @param DateTime|null $publishedAt
     *
     * @return $this
     */
    public function setPublishedAt(\DateTime $publishedAt = null)
    {
        $this->publishedAt = $publishedAt;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getUnPublishedAt()
    {
        return $this->unPublishedAt;
    }

    /**
     * @param DateTime|null $unPublishedAt
     *
     * @return $this
     */
    public function setUnPublishedAt(\DateTime $unPublishedAt = null)
    {
        $this->unPublishedAt = $unPublishedAt;

        return $this;
    }
}
