<?php

namespace Comitium5\DesignerBundle\Model\Traits\Metadata;

use Doctrine\ORM\QueryBuilder;

/**
 * Trait MetaDataRepositoryTrait
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Traits\Metadata
 */
trait MetaDataRepositoryTrait
{
	/**
	 * @param string $slug
	 * @return QueryBuilder
	 */
	public function findBySlug($slug)
	{
		$builder = $this->createQueryBuilder($this->getAlias());
		$builder->leftJoin($this->getAlias().'.langs', $this->getAlias().'l');
		$builder->andWhere($this->getAlias().'l.slug = :slug');
		$builder->setParameter('slug', $slug);
	
		return $builder;
	}
}