<?php

namespace Comitium5\DesignerBundle\Model\Traits\Layout;


use Comitium5\DesignerBundle\Model\Interfaces\Layout\LayoutPageInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Page\PageInterface;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Trait LayoutPageCollectionTrait
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Traits\Layout
 */
trait LayoutPageCollectionTrait
{
	/**
	 * @var ArrayCollection
	 */
	protected $layoutPages;

	/**
	 * @param LayoutPageInterface $layoutPage
	 * @return self
	 */
	public function addLayoutPage(LayoutPageInterface $layoutPage)
	{
		if (!$this->layoutPages->contains($layoutPage)) {
			if ($this instanceof PageInterface) {
				$layoutPage->setPage($this);
			} else {
				$layoutPage->setLayout($this);
			}
			$this->layoutPages->add($layoutPage);
		}
		return $this;
	}
	/**
	 * @param LayoutPageInterface $layoutPage
	 * @return self
	 */
	public function removeLayoutPage(LayoutPageInterface $layoutPage)
	{
		$this->layoutPages->removeElement($layoutPage);
		return $this;
	}
	/**
	 * @return ArrayCollection
	 */
	public function getLayoutPages()
	{
		return $this->layoutPages;
	}
	/**
	 * @param ArrayCollection $layoutPages
	 * @return self
	 */
	public function setLayoutPages(ArrayCollection $layoutPages)
	{
		$this->layoutPages = $layoutPages;
		return $this;
	}
}
