<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\View;

use Comitium5\DesignerBundle\Model\Interfaces\DateTimeInterface;
use Comitium5\DesignerBundle\Model\Interfaces\IdentifiableInterface;

/**
 * interface ViewInterface
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\View
 */
interface ViewInterface extends IdentifiableInterface, DateTimeInterface
{
    /**
     * @return string
     */
    public function getName(): string;

    /**
     * @param string $name
     *
     * @return $this
     */
    public function setName(string $name);

    /**
     * @return string
     */
    public function getContent(): string;

    /**
     * @param string $content
     *
     * @return $this
     */
    public function setContent(string $content);
}
