<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Page;

use Comitium5\DesignerBundle\Entity\Template;
use Comitium5\DesignerBundle\Model\Interfaces\Template\TemplateInterface;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Interface PageRepository
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Page
 */
interface PageRepositoryInterface
{
    /**
     * @param int $pageId
     *
     * @return DesignerPageInterface|null
     */
    public function getPage(int $pageId): ?DesignerPageInterface;

    /**
     * @param int $originId
     *
     * @return DesignerPageInterface|null
     */
    public function getPageFromOrigin(int $originId): ?DesignerPageInterface;

    /**
     * @param DesignerPageInterface $page
     *
     * @return DesignerPageInterface
     */
    public function savePage(DesignerPageInterface $page): DesignerPageInterface;

    /**
     * @param DesignerPageInterface $page
     */
    public function removePage(DesignerPageInterface $page): void;

    /**
     * @param TemplateInterface $template
     *
     * @return ArrayCollection|null
     */
    public function findByTemplate(TemplateInterface $template) : ?array;
}
