<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Page;

use Comitium5\DesignerBundle\Model\Interfaces\DateTimeInterface;
use Comitium5\DesignerBundle\Model\Interfaces\IndexableInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Layout\LayoutPageCollectionInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Node\NodeInterface;
use Comitium5\DesignerBundle\Model\Interfaces\PublishDateInterface;
use Comitium5\DesignerBundle\Model\Interfaces\SelfContentTypeInterface;
use Comitium5\DesignerBundle\Model\Interfaces\SortableInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Privacy\PrivacyInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Template\TemplateRelationInterface;
use Comitium5\DesignerBundle\Model\Interfaces\TmpIdentifierInterface;
use Comitium5\DesignerBundle\Model\Interfaces\View\ViewCollectionInterface;

/**
 * Interface PageInterface
 *
 * @author Fernando Pradas <fernando@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Page
 */
interface PageInterface extends
    DateTimeInterface,
    SelfContentTypeInterface,
    TemplateRelationInterface,
    PublishDateInterface,
    LayoutPageCollectionInterface,
    ViewCollectionInterface,
    DesignerPageInterface
{
    /**
     * @return string
     */
    public function getType();

    /**
     * @param $type
     *
     * @return mixed
     */
    public function setType($type);

    /**
     * @param bool|false $temporary
     * @return mixed
     */
    public function getFilePath($temporary = false);

    /**
     * @return mixed
     */
    public function allowedToInsertResourcesOnTwigTemplates();
}
