<?php

namespace Comitium5\DesignerBundle\Model\Interfaces;

/**
 * Interface IdentifiableInterface
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces
 */
interface IdentifiableInterface
{
    /**
     * @param int|null $id
     *
     * @return IdentifiableInterface
     */
    public function setId(int $id = null): IdentifiableInterface;

    /**
     * @return int|null
     */
    public function getId(): ?int;

    /**
     * @param string|null $uuid
     *
     * @return IdentifiableInterface
     */
    public function setUuid(string $uuid = null): IdentifiableInterface;

    /**
     * @return string|null
     */
    public function getUuid(): ?string;
}
