<?php

namespace Comitium5\DesignerBundle\Model\Interfaces\Css;

use Comitium5\DesignerBundle\Entity\RelTemplateCss;
use Doctrine\Common\Collections\Collection;

/**
 * Interface CssRelationInterface
 * 
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Model\Interfaces\Css
 */
interface CssCollectionInterface
{
    /**
     * @param RelTemplateCss $css
     *
     * @return self
     */
    public function addCss(RelTemplateCss $css);

    /**
     * @param RelTemplateCss $css
     *
     * @return self
     */
    public function removeCss(RelTemplateCss $css);

    /**
     * @return Collection
     */
    public function getCss();

    /**
     * @param Collection $css
     *
     * @return self
     */
    public function setCss(Collection $css);
}
